/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import org.apache.gobblin.util.PortUtils;

public class JvmUtils {
    private static final Joiner JOINER = Joiner.on((String)" ").skipNulls();
    private static final PortUtils PORT_UTILS = new PortUtils();

    private JvmUtils() {
    }

    public static String getJvmInputArguments() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        return String.format("JVM Input Arguments: %s", JOINER.join(arguments));
    }

    public static String formatJvmArguments(Optional<String> jvmArguments) {
        if (jvmArguments.isPresent()) {
            return PORT_UTILS.replacePortTokens((String)jvmArguments.get());
        }
        return "";
    }
}

