/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.util.LoggingUncaughtExceptionHandler;
import org.apache.gobblin.util.executors.MDCPropagatingCallable;
import org.apache.gobblin.util.executors.MDCPropagatingExecutorService;
import org.apache.gobblin.util.executors.MDCPropagatingRunnable;
import org.apache.gobblin.util.executors.MDCPropagatingScheduledExecutorService;
import org.slf4j.Logger;

public class ExecutorsUtils {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = ExecutorsUtils.newThreadFactory((Optional<Logger>)Optional.absent());
    public static final long EXECUTOR_SERVICE_SHUTDOWN_TIMEOUT = 60L;
    public static final TimeUnit EXECUTOR_SERVICE_SHUTDOWN_TIMEOUT_TIMEUNIT = TimeUnit.SECONDS;

    public static ThreadFactory defaultThreadFactory() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static ThreadFactory newThreadFactory(Optional<Logger> logger) {
        return ExecutorsUtils.newThreadFactory(logger, (Optional<String>)Optional.absent());
    }

    public static ThreadFactory newThreadFactory(Optional<Logger> logger, Optional<String> nameFormat) {
        return ExecutorsUtils.newThreadFactory(new ThreadFactoryBuilder(), logger, nameFormat);
    }

    public static ThreadFactory newDaemonThreadFactory(Optional<Logger> logger, Optional<String> nameFormat) {
        return ExecutorsUtils.newThreadFactory(new ThreadFactoryBuilder().setDaemon(true), logger, nameFormat);
    }

    private static ThreadFactory newThreadFactory(ThreadFactoryBuilder builder, Optional<Logger> logger, Optional<String> nameFormat) {
        if (nameFormat.isPresent()) {
            builder.setNameFormat((String)nameFormat.get());
        }
        return builder.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler(logger)).build();
    }

    public static ListeningExecutorService loggingDecorator(ExecutorService executorService) {
        return new MDCPropagatingExecutorService(executorService);
    }

    public static ListeningScheduledExecutorService loggingDecorator(ScheduledExecutorService scheduledExecutorService) {
        return new MDCPropagatingScheduledExecutorService(scheduledExecutorService);
    }

    public static Runnable loggingDecorator(Runnable runnable) {
        if (runnable instanceof MDCPropagatingRunnable) {
            return runnable;
        }
        return new MDCPropagatingRunnable(runnable);
    }

    public static <T> Callable<T> loggingDecorator(Callable<T> callable) {
        if (callable instanceof MDCPropagatingCallable) {
            return callable;
        }
        return new MDCPropagatingCallable<T>(callable);
    }

    public static void shutdownExecutorService(ExecutorService executorService, Optional<Logger> logger, long timeout, TimeUnit unit) {
        block8: {
            Preconditions.checkNotNull((Object)((Object)unit));
            executorService.shutdown();
            if (logger.isPresent()) {
                ((Logger)logger.get()).info("Attempting to shutdown ExecutorService: " + executorService);
            }
            try {
                long halfTimeoutNanos = TimeUnit.NANOSECONDS.convert(timeout, unit) / 2L;
                if (!executorService.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS)) {
                    executorService.shutdownNow();
                    if (logger.isPresent()) {
                        ((Logger)logger.get()).info("Shutdown un-successful, attempting shutdownNow of ExecutorService: " + executorService);
                    }
                    if (!executorService.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS) && logger.isPresent()) {
                        ((Logger)logger.get()).error("Could not shutdown all threads in ExecutorService: " + executorService);
                    }
                } else if (logger.isPresent()) {
                    ((Logger)logger.get()).info("Successfully shutdown ExecutorService: " + executorService);
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                executorService.shutdownNow();
                if (!logger.isPresent()) break block8;
                ((Logger)logger.get()).info("Attempting to shutdownNow ExecutorService: " + executorService);
            }
        }
    }

    public static void shutdownExecutorService(ExecutorService executorService, Optional<Logger> logger) {
        ExecutorsUtils.shutdownExecutorService(executorService, logger, 60L, EXECUTOR_SERVICE_SHUTDOWN_TIMEOUT_TIMEUNIT);
    }

    public static <F, T> List<T> parallelize(List<F> list, final Function<F, T> function, int threadCount, int timeoutInSecs, Optional<Logger> logger) throws ExecutionException {
        Preconditions.checkArgument((list != null ? 1 : 0) != 0, (Object)"Input list can not be null");
        Preconditions.checkArgument((function != null ? 1 : 0) != 0, (Object)"Function can not be null");
        ArrayList results = Lists.newArrayListWithCapacity((int)list.size());
        ArrayList futures = Lists.newArrayListWithCapacity((int)list.size());
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(threadCount, ExecutorsUtils.newThreadFactory(logger))), (long)2L, (TimeUnit)TimeUnit.MINUTES);
        for (final F l : list) {
            futures.add(executorService.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return function.apply(l);
                }
            }));
        }
        ExecutorsUtils.shutdownExecutorService(executorService, logger, timeoutInSecs, TimeUnit.SECONDS);
        for (Future future : futures) {
            try {
                results.add(future.get());
            }
            catch (InterruptedException e) {
                throw new ExecutionException("Thread interrupted", e);
            }
        }
        return results;
    }
}

