/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gobblin.util.ClustersNames;
import org.apache.hadoop.conf.Configuration;

public class ClusterNameTags {
    public static final String CLUSTER_IDENTIFIER_TAG_NAME = "clusterIdentifier";

    public static Map<String, String> getClusterNameTags() {
        return ClusterNameTags.getClusterNameTags(new Configuration());
    }

    public static Map<String, String> getClusterNameTags(Configuration conf) {
        ImmutableMap.Builder tagMap = ImmutableMap.builder();
        String clusterIdentifierTag = ClustersNames.getInstance().getClusterName(conf);
        if (!Strings.isNullOrEmpty((String)clusterIdentifierTag)) {
            tagMap.put((Object)CLUSTER_IDENTIFIER_TAG_NAME, (Object)clusterIdentifierTag);
        }
        return tagMap.build();
    }
}

