/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.example.wikipedia;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.converter.ToAvroConverterBase;

public class WikipediaConverter
extends ToAvroConverterBase<String, JsonElement> {
    private static final String JSON_CONTENT_MEMBER = "content";
    private static final Gson GSON = new Gson();
    private static final Type FIELD_ENTRY_TYPE = new TypeToken<Map<String, Object>>(){}.getType();

    public Schema convertSchema(String schema, WorkUnitState workUnit) {
        return new Schema.Parser().parse(schema);
    }

    public Iterable<GenericRecord> convertRecord(Schema outputSchema, JsonElement inputRecord, WorkUnitState workUnit) {
        JsonElement element = (JsonElement)GSON.fromJson(inputRecord, JsonElement.class);
        Map fields = (Map)GSON.fromJson(element, FIELD_ENTRY_TYPE);
        GenericData.Record record = new GenericData.Record(outputSchema);
        for (Map.Entry entry : fields.entrySet()) {
            if (((String)entry.getKey()).equals("*")) {
                record.put(JSON_CONTENT_MEMBER, entry.getValue());
                continue;
            }
            if (outputSchema.getField((String)entry.getKey()) == null) continue;
            record.put((String)entry.getKey(), entry.getValue());
        }
        return new SingleRecordIterable((Object)record);
    }
}

