/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.retry.backoff;

import com.linkedin.parseq.internal.ArgumentUtil;
import com.linkedin.parseq.retry.backoff.BackoffPolicy;
import java.util.concurrent.ThreadLocalRandom;

public class RandomizedBackoff
implements BackoffPolicy {
    protected final BackoffPolicy _policy;
    protected final long _minRange;
    protected final long _maxRange;

    public RandomizedBackoff(BackoffPolicy policy, long minRange, long maxRange) {
        ArgumentUtil.requireNotNull(policy, "policy");
        if (maxRange <= minRange) {
            throw new IllegalArgumentException(String.format("minRange %s must be strictly less than maxRange %s", minRange, maxRange));
        }
        this._policy = policy;
        this._minRange = minRange;
        this._maxRange = maxRange;
    }

    @Override
    public long nextBackoff(int attempts, Throwable error) {
        return this._policy.nextBackoff(attempts, error) + this._minRange + Math.round((double)(this._maxRange - this._minRange) * ThreadLocalRandom.current().nextDouble());
    }
}

