/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.retry.backoff;

import com.linkedin.parseq.retry.backoff.ConstantBackoff;
import com.linkedin.parseq.retry.backoff.ExponentialBackoff;
import com.linkedin.parseq.retry.backoff.FibonacciBackoff;
import com.linkedin.parseq.retry.backoff.LinearBackoff;
import com.linkedin.parseq.retry.backoff.RandomizedBackoff;
import com.linkedin.parseq.retry.backoff.SelectedBackoff;
import java.util.function.Function;

public interface BackoffPolicy {
    public long nextBackoff(int var1, Throwable var2);

    public static BackoffPolicy noBackoff() {
        return (attempts, error) -> 0L;
    }

    public static BackoffPolicy constant(long backoff) {
        return new ConstantBackoff(backoff);
    }

    public static BackoffPolicy linear(long backoff) {
        return new LinearBackoff(backoff);
    }

    public static BackoffPolicy exponential(long backoff) {
        return new ExponentialBackoff(backoff);
    }

    public static BackoffPolicy fibonacci(long backoff) {
        return new FibonacciBackoff(backoff);
    }

    public static BackoffPolicy randomized(BackoffPolicy policy, long minRange, long maxRange) {
        return new RandomizedBackoff(policy, minRange, maxRange);
    }

    public static BackoffPolicy selected(Function<Throwable, BackoffPolicy> policyFunction) {
        return new SelectedBackoff(policyFunction);
    }
}

