/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.CancellationException;
import com.linkedin.parseq.EarlyFinishException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;

public class Exceptions {
    public static final Exception EARLY_FINISH_EXCEPTION = Exceptions.sanitize(new EarlyFinishException("Task execution cancelled because it's promise was already completed"));
    public static final Exception TIMEOUT_EXCEPTION = Exceptions.sanitize(new TimeoutException());
    public static final Exception NO_SUCH_ELEMENT_EXCEPTION = Exceptions.sanitize(new NoSuchElementException());

    private Exceptions() {
    }

    private static Exception sanitize(Exception e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace.length > 0) {
            e.setStackTrace(Arrays.copyOf(e.getStackTrace(), 1));
        }
        return e;
    }

    public static Exception noSuchElement() {
        return NO_SUCH_ELEMENT_EXCEPTION;
    }

    private static Exception addCause(Exception e, Throwable cause) {
        return (Exception)e.initCause(cause);
    }

    public static Exception noSuchElement(Throwable cause) {
        return Exceptions.addCause(new NoSuchElementException(), cause);
    }

    public static boolean isCancellation(Throwable e) {
        return e instanceof CancellationException;
    }

    public static boolean isEarlyFinish(Throwable e) {
        return Exceptions.isCancellation(e) && e.getCause() instanceof EarlyFinishException;
    }

    private static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String failureToString(Throwable e) {
        if (Exceptions.isCancellation(e)) {
            if (Exceptions.isEarlyFinish(e)) {
                return "";
            }
            return "cancelled because: " + Exceptions.toString(e.getCause());
        }
        return Exceptions.toString(e);
    }

    public static Exception timeoutException(String desc) {
        if (desc == null || desc.isEmpty()) {
            return TIMEOUT_EXCEPTION;
        }
        return new TimeoutException(desc);
    }
}

