/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.DelayedExecutor;
import com.linkedin.parseq.DelayedExecutorAdapter;
import com.linkedin.parseq.Engine;
import com.linkedin.parseq.IndirectDelayedExecutor;
import com.linkedin.parseq.TaskQueueFactory;
import com.linkedin.parseq.internal.ArgumentUtil;
import com.linkedin.parseq.internal.CachedLoggerFactory;
import com.linkedin.parseq.internal.FIFOPriorityQueue;
import com.linkedin.parseq.internal.PlanCompletionListener;
import com.linkedin.parseq.internal.PlanDeactivationListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class EngineBuilder {
    private Executor _taskExecutor;
    private DelayedExecutor _timerScheduler;
    private ILoggerFactory _loggerFactory;
    private PlanDeactivationListener _planDeactivationListener;
    private PlanCompletionListener _planCompletionListener;
    private TaskQueueFactory _taskQueueFactory;
    private Map<String, Object> _properties = new HashMap<String, Object>();

    public void setPlanDeactivationListener(PlanDeactivationListener planDeactivationListener) {
        ArgumentUtil.requireNotNull(planDeactivationListener, "planDeactivationListener");
        this._planDeactivationListener = planDeactivationListener;
    }

    public EngineBuilder setPlanCompletionListener(PlanCompletionListener planCompletionListener) {
        ArgumentUtil.requireNotNull(planCompletionListener, "planCompletionListener");
        this._planCompletionListener = planCompletionListener;
        return this;
    }

    public EngineBuilder setTaskQueueFactory(TaskQueueFactory taskQueueFactory) {
        ArgumentUtil.requireNotNull(taskQueueFactory, "taskQueueFactory");
        this._taskQueueFactory = taskQueueFactory;
        return this;
    }

    public EngineBuilder setTaskExecutor(Executor taskExecutor) {
        ArgumentUtil.requireNotNull(taskExecutor, "taskExecutor");
        this._taskExecutor = taskExecutor;
        return this;
    }

    public EngineBuilder setTimerScheduler(DelayedExecutor timerScheduler) {
        ArgumentUtil.requireNotNull(timerScheduler, "timerScheduler");
        this._timerScheduler = timerScheduler;
        return this;
    }

    public EngineBuilder setTimerScheduler(ScheduledExecutorService timerScheduler) {
        ArgumentUtil.requireNotNull(timerScheduler, "timerScheduler");
        this.setTimerScheduler(EngineBuilder.adaptTimerScheduler(timerScheduler));
        return this;
    }

    public EngineBuilder setLoggerFactory(ILoggerFactory loggerFactory) {
        ArgumentUtil.requireNotNull(loggerFactory, "loggerFactory");
        this._loggerFactory = loggerFactory;
        return this;
    }

    public EngineBuilder setEngineProperty(String key, Object value) {
        this._properties.put(key, value);
        return this;
    }

    public Engine build() {
        if (this._taskExecutor == null) {
            throw new IllegalStateException("Task executor is required to create an Engine, but it is not set");
        }
        if (this._timerScheduler == null) {
            throw new IllegalStateException("Timer scheduler is required to create an Engine, but it is not set");
        }
        return new Engine(this._taskExecutor, new IndirectDelayedExecutor(this._timerScheduler), (ILoggerFactory)(this._loggerFactory != null ? this._loggerFactory : new CachedLoggerFactory(LoggerFactory.getILoggerFactory())), this._properties, this._planDeactivationListener != null ? this._planDeactivationListener : planContext -> {}, this._planCompletionListener != null ? this._planCompletionListener : planContext -> {}, this._taskQueueFactory != null ? this._taskQueueFactory : FIFOPriorityQueue::new);
    }

    private static DelayedExecutor adaptTimerScheduler(ScheduledExecutorService timerScheduler) {
        return new DelayedExecutorAdapter(timerScheduler);
    }

    PlanCompletionListener getPlanCompletionListener() {
        return this._planCompletionListener;
    }
}

