/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.test;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.testng.Assert;

public class RetentionTestDataGenerator {
    private static final String DATA_GENERATOR_KEY = "gobblin.test";
    private static final String DATA_GENERATOR_PREFIX = "gobblin.test.";
    private static final String TEST_CURRENT_TIME_KEY = "gobblin.test.currentTime";
    private static final String TEST_DATA_CREATE_KEY = "gobblin.test.create";
    private static final String TEST_DATA_VALIDATE_RETAINED_KEY = "gobblin.test.validate.retained";
    private static final String TEST_DATA_VALIDATE_DELETED_KEY = "gobblin.test.validate.deleted";
    private static final String TEST_DATA_VALIDATE_PERMISSIONS_KEY = "gobblin.test.validate.permissions";
    private static final String TEST_DATA_PATH_LOCAL_KEY = "path";
    private static final String TEST_DATA_MOD_TIME_LOCAL_KEY = "modTime";
    private static final String TEST_DATA_PERMISSIONS_KEY = "permission";
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"MM/dd/yyyy HH:mm:ss").withZone(DateTimeZone.forID((String)"America/Los_Angeles"));
    private final Path testTempDirPath;
    private final FileSystem fs;
    private final Config setupConfig;

    public RetentionTestDataGenerator(Path testTempDirPath, Path testSetupConfPath, FileSystem fs) {
        this.fs = fs;
        this.testTempDirPath = testTempDirPath;
        this.setupConfig = ConfigFactory.parseResources((String)PathUtils.getPathWithoutSchemeAndAuthority((Path)testSetupConfPath).toString());
        if (!this.setupConfig.hasPath(DATA_GENERATOR_KEY)) {
            throw new RuntimeException(String.format("Failed to load setup config at %s", testSetupConfPath.toString()));
        }
    }

    public void setup() throws IOException {
        if (this.setupConfig.hasPath(TEST_CURRENT_TIME_KEY)) {
            DateTimeUtils.setCurrentMillisProvider((DateTimeUtils.MillisProvider)new FixedThreadLocalMillisProvider(FORMATTER.parseDateTime(this.setupConfig.getString(TEST_CURRENT_TIME_KEY)).getMillis()));
        }
        List createConfigs = this.setupConfig.getConfigList(TEST_DATA_CREATE_KEY);
        Collections.sort(createConfigs, new Comparator<Config>(){

            @Override
            public int compare(Config o1, Config o2) {
                return o1.getString(RetentionTestDataGenerator.TEST_DATA_PATH_LOCAL_KEY).compareTo(o2.getString(RetentionTestDataGenerator.TEST_DATA_PATH_LOCAL_KEY));
            }
        });
        for (Config fileToCreate : createConfigs) {
            File file;
            boolean modifiedFile;
            Path fullFilePath = new Path(this.testTempDirPath, PathUtils.withoutLeadingSeparator((Path)new Path(fileToCreate.getString(TEST_DATA_PATH_LOCAL_KEY))));
            if (!this.fs.mkdirs(fullFilePath)) {
                throw new RuntimeException("Failed to create test file " + fullFilePath);
            }
            if (fileToCreate.hasPath(TEST_DATA_MOD_TIME_LOCAL_KEY) && !(modifiedFile = (file = new File(PathUtils.getPathWithoutSchemeAndAuthority((Path)fullFilePath).toString())).setLastModified(FORMATTER.parseMillis(fileToCreate.getString(TEST_DATA_MOD_TIME_LOCAL_KEY))))) {
                throw new IOException(String.format("Unable to set the last modified time for file %s!", file));
            }
            if (!fileToCreate.hasPath(TEST_DATA_PERMISSIONS_KEY)) continue;
            this.fs.setPermission(fullFilePath, new FsPermission(fileToCreate.getString(TEST_DATA_PERMISSIONS_KEY)));
        }
    }

    public void validate() throws IOException {
        List retainedConfigs = this.setupConfig.getConfigList(TEST_DATA_VALIDATE_RETAINED_KEY);
        for (Object retainedConfig : retainedConfigs) {
            Path fullFilePath = new Path(this.testTempDirPath, PathUtils.withoutLeadingSeparator((Path)new Path(retainedConfig.getString(TEST_DATA_PATH_LOCAL_KEY))));
            Assert.assertTrue((boolean)this.fs.exists(fullFilePath), (String)String.format("%s should not be deleted", fullFilePath.toString()));
        }
        List deletedConfigs = this.setupConfig.getConfigList(TEST_DATA_VALIDATE_DELETED_KEY);
        for (Config retainedConfig : deletedConfigs) {
            Path fullFilePath = new Path(this.testTempDirPath, PathUtils.withoutLeadingSeparator((Path)new Path(retainedConfig.getString(TEST_DATA_PATH_LOCAL_KEY))));
            Assert.assertFalse((boolean)this.fs.exists(fullFilePath), (String)String.format("%s should be deleted", fullFilePath.toString()));
        }
        if (this.setupConfig.hasPath(TEST_DATA_VALIDATE_PERMISSIONS_KEY)) {
            List permissionsConfigs = this.setupConfig.getConfigList(TEST_DATA_VALIDATE_PERMISSIONS_KEY);
            for (Config permissionsConfig : permissionsConfigs) {
                Path fullFilePath = new Path(this.testTempDirPath, PathUtils.withoutLeadingSeparator((Path)new Path(permissionsConfig.getString(TEST_DATA_PATH_LOCAL_KEY))));
                Assert.assertEquals((Object)this.fs.getFileStatus(fullFilePath).getPermission(), (Object)new FsPermission(permissionsConfig.getString(TEST_DATA_PERMISSIONS_KEY)), (String)String.format("Permissions check failed for %s", fullFilePath));
            }
        }
        this.cleanup();
    }

    public void cleanup() throws IOException {
        DateTimeUtils.setCurrentMillisSystem();
        if (this.fs.exists(this.testTempDirPath) && !this.fs.delete(this.testTempDirPath, true)) {
            throw new IOException("Failed to clean up path " + this.testTempDirPath);
        }
    }

    public static class FixedThreadLocalMillisProvider
    implements DateTimeUtils.MillisProvider {
        private ThreadLocal<Long> currentTimeThreadLocal = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return System.currentTimeMillis();
            }
        };

        public FixedThreadLocalMillisProvider(Long millis) {
            this.currentTimeThreadLocal.set(millis);
        }

        public long getMillis() {
            return this.currentTimeThreadLocal.get();
        }
    }
}

