/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.commit;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.data.management.trash.Trash;
import org.apache.gobblin.data.management.trash.TrashFactory;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DeleteFileCommitStep
implements CommitStep {
    private final Collection<FileStatus> pathsToDelete;
    private final Properties properties;
    private final URI fsUri;
    private final Optional<Path> parentDeletionLimit;

    public DeleteFileCommitStep(FileSystem fs, Path path, Properties properties) throws IOException {
        this(fs, Lists.newArrayList((Object[])new FileStatus[]{fs.getFileStatus(path)}), properties, (Optional<Path>)Optional.absent());
    }

    public static DeleteFileCommitStep fromPaths(FileSystem fs, Collection<Path> paths, Properties properties) throws IOException {
        return new DeleteFileCommitStep(fs, DeleteFileCommitStep.toFileStatus(fs, paths), properties, (Optional<Path>)Optional.absent());
    }

    public static DeleteFileCommitStep fromPaths(FileSystem fs, Collection<Path> paths, Properties properties, Path parentDeletionLimit) throws IOException {
        return new DeleteFileCommitStep(fs, DeleteFileCommitStep.toFileStatus(fs, paths), properties, (Optional<Path>)Optional.of((Object)parentDeletionLimit));
    }

    public DeleteFileCommitStep(FileSystem fs, Collection<FileStatus> paths, Properties properties, Optional<Path> parentDeletionLimit) throws IOException {
        this.fsUri = fs.getUri();
        this.pathsToDelete = paths;
        this.properties = properties;
        this.parentDeletionLimit = parentDeletionLimit;
    }

    private static List<FileStatus> toFileStatus(FileSystem fs, Collection<Path> paths) throws IOException {
        ArrayList fileStatuses = Lists.newArrayList();
        for (Path path : paths) {
            fileStatuses.add(fs.getFileStatus(path));
        }
        return fileStatuses;
    }

    public boolean isCompleted() throws IOException {
        for (FileStatus pathToDelete : this.pathsToDelete) {
            if (!this.existsAndIsExpectedFile(pathToDelete)) continue;
            return false;
        }
        return true;
    }

    public void execute() throws IOException {
        Trash trash = TrashFactory.createTrash(this.getFS(), this.properties);
        HashSet parents = Sets.newHashSet();
        for (FileStatus pathToDelete : this.pathsToDelete) {
            if (!this.existsAndIsExpectedFile(pathToDelete)) continue;
            trash.moveToTrash(pathToDelete.getPath());
            parents.add(pathToDelete.getPath().getParent());
        }
        if (this.parentDeletionLimit.isPresent()) {
            for (Path parent : parents) {
                PathUtils.deleteEmptyParentDirectories((FileSystem)this.getFS(), (Path)((Path)this.parentDeletionLimit.get()), (Path)parent);
            }
        }
    }

    private boolean existsAndIsExpectedFile(FileStatus status) throws IOException {
        if (!this.getFS().exists(status.getPath())) {
            return false;
        }
        FileStatus currentFileStatus = this.getFS().getFileStatus(status.getPath());
        return currentFileStatus.getLen() == status.getLen() && currentFileStatus.getModificationTime() <= status.getModificationTime();
    }

    private FileSystem getFS() throws IOException {
        return FileSystem.get((URI)this.fsUri, (Configuration)new Configuration());
    }

    public String toString() {
        return String.format("Delete the following files at %s: %s", this.fsUri, Iterables.toString((Iterable)Iterables.transform(this.pathsToDelete, (Function)new Function<FileStatus, Path>(){

            @Nullable
            public Path apply(@Nullable FileStatus input) {
                return input != null ? input.getPath() : null;
            }
        })));
    }

    public Collection<FileStatus> getPathsToDelete() {
        return this.pathsToDelete;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public URI getFsUri() {
        return this.fsUri;
    }

    public Optional<Path> getParentDeletionLimit() {
        return this.parentDeletionLimit;
    }
}

