/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.retention;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.data.management.retention.DatasetCleaner;
import org.apache.gobblin.runtime.cli.CliApplication;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

@Alias(value="cleaner", description="Data retention utility")
public class DatasetCleanerCli
implements CliApplication {
    private static final Option CLEANER_CONFIG = Option.builder((String)"c").longOpt("config").hasArg().required().desc("DatasetCleaner configuration").build();

    public void run(String[] args) {
        try {
            Properties properties = this.readProperties(this.parseConfigLocation(args));
            DatasetCleaner datasetCleaner = new DatasetCleaner(FileSystem.get((Configuration)new Configuration()), properties);
            datasetCleaner.clean();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Properties readProperties(String fileLocation) {
        try {
            Properties prop = new Properties();
            FileInputStream input = new FileInputStream(fileLocation);
            prop.load(input);
            input.close();
            return prop;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String parseConfigLocation(String[] args) {
        CommandLine cli;
        Options options = new Options();
        options.addOption(CLEANER_CONFIG);
        try {
            DefaultParser parser = new DefaultParser();
            cli = parser.parse(options, Arrays.copyOfRange(args, 1, args.length));
        }
        catch (ParseException pe) {
            System.out.println("Command line parse exception: " + pe.getMessage());
            this.printUsage(options);
            throw new RuntimeException(pe);
        }
        return cli.getOptionValue(CLEANER_CONFIG.getOpt());
    }

    private void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String usage = "DatasetCleaner configuration ";
        formatter.printHelp(usage, options);
    }
}

