/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version.finder;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.typesafe.config.Config;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.data.management.version.TimestampedHiveDatasetVersion;
import org.apache.gobblin.data.management.version.finder.AbstractHiveDatasetVersionFinder;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DatePartitionHiveVersionFinder
extends AbstractHiveDatasetVersionFinder {
    public static final String PARTITION_VALUE_DATE_TIME_PATTERN_KEY = "hive.partition.value.datetime.pattern";
    public static final String DEFAULT_PARTITION_VALUE_DATE_TIME_PATTERN = "yyyy-MM-dd-HH";
    public static final String PARTITION_VALUE_DATE_TIME_TIMEZONE_KEY = "hive.partition.value.datetime.timezone";
    public static final String DEFAULT_PARTITION_VALUE_DATE_TIME_TIMEZONE = "America/Los_Angeles";
    public static final String PARTITION_KEY_NAME_KEY = "hive.partition.key.name";
    public static final String DEFAULT_PARTITION_KEY_NAME = "datepartition";
    protected final DateTimeFormatter formatter;
    private final String partitionKeyName;
    private final Predicate<FieldSchema> partitionKeyNamePredicate;
    private final String pattern;

    public DatePartitionHiveVersionFinder(FileSystem fs, Config config) {
        this.pattern = ConfigUtils.getString((Config)config, (String)PARTITION_VALUE_DATE_TIME_PATTERN_KEY, (String)DEFAULT_PARTITION_VALUE_DATE_TIME_PATTERN);
        this.formatter = config.hasPath(PARTITION_VALUE_DATE_TIME_TIMEZONE_KEY) ? DateTimeFormat.forPattern((String)this.pattern).withZone(DateTimeZone.forID((String)config.getString(PARTITION_VALUE_DATE_TIME_TIMEZONE_KEY))) : DateTimeFormat.forPattern((String)this.pattern).withZone(DateTimeZone.forID((String)DEFAULT_PARTITION_VALUE_DATE_TIME_TIMEZONE));
        this.partitionKeyName = ConfigUtils.getString((Config)config, (String)PARTITION_KEY_NAME_KEY, (String)DEFAULT_PARTITION_KEY_NAME);
        this.partitionKeyNamePredicate = new Predicate<FieldSchema>(){

            public boolean apply(FieldSchema input) {
                return StringUtils.equalsIgnoreCase((CharSequence)input.getName(), (CharSequence)DatePartitionHiveVersionFinder.this.partitionKeyName);
            }
        };
    }

    @Override
    protected TimestampedHiveDatasetVersion getDatasetVersion(Partition partition) {
        int index = Iterables.indexOf((Iterable)partition.getTable().getPartitionKeys(), this.partitionKeyNamePredicate);
        if (index == -1) {
            throw new IllegalArgumentException(String.format("Failed to find partition key %s in the table %s", this.partitionKeyName, partition.getTable().getCompleteName()));
        }
        if (index >= partition.getValues().size()) {
            throw new IllegalArgumentException(String.format("Failed to find partition value for key %s in the partition %s", this.partitionKeyName, partition.getName()));
        }
        return new TimestampedHiveDatasetVersion(this.formatter.parseDateTime(((String)partition.getValues().get(index)).trim().substring(0, this.pattern.length())), partition);
    }
}

