/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.StringDatasetVersion;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;

public class FileStatusDatasetVersion
extends StringDatasetVersion {
    protected final FileStatus fileStatus;

    public FileStatusDatasetVersion(FileStatus fileStatus) {
        super(fileStatus.getPath().getName(), fileStatus.getPath());
        this.fileStatus = fileStatus;
    }

    @Override
    public int compareTo(FileSystemDatasetVersion other) {
        FileStatusDatasetVersion otherAsFileStatus = (FileStatusDatasetVersion)other;
        return this.fileStatus.getPath().compareTo((Object)otherAsFileStatus.getFileStatus().getPath());
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass()) && this.compareTo((FileSystemDatasetVersion)obj) == 0;
    }

    @Override
    public int hashCode() {
        return this.fileStatus.hashCode();
    }

    @Override
    public Set<Path> getPaths() {
        return Sets.newHashSet((Object[])new Path[]{this.fileStatus.getPath()});
    }

    public FileStatus getFileStatus() {
        return this.fileStatus;
    }

    @Override
    public String toString() {
        return "FileStatusDatasetVersion(fileStatus=" + this.getFileStatus() + ")";
    }
}

