/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.source;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.source.DatasetFinderSource;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.IterableDatasetFinder;
import org.apache.gobblin.dataset.PartitionableDataset;
import org.apache.gobblin.dataset.URNIdentified;
import org.apache.gobblin.dataset.comparators.URNLexicographicalComparator;
import org.apache.gobblin.runtime.task.NoopTask;
import org.apache.gobblin.source.workunit.BasicWorkUnitStream;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.source.workunit.WorkUnitStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoopingDatasetFinderSource<S, D>
extends DatasetFinderSource<S, D> {
    private static final Logger log = LoggerFactory.getLogger(LoopingDatasetFinderSource.class);
    public static final String MAX_WORK_UNITS_PER_RUN_KEY = "gobblin.source.loopingDatasetFinderSource.maxWorkUnitsPerRun";
    public static final int MAX_WORK_UNITS_PER_RUN = 10;
    private static final String DATASET_URN = "gobblin.source.loopingDatasetFinderSource.datasetUrn";
    private static final String PARTITION_URN = "gobblin.source.loopingDatasetFinderSource.partitionUrn";
    private static final String WORK_UNIT_ORDINAL = "gobblin.source.loopingDatasetFinderSource.workUnitOrdinal";
    protected static final String END_OF_DATASETS_KEY = "gobblin.source.loopingDatasetFinderSource.endOfDatasets";
    private final URNLexicographicalComparator lexicographicalComparator = new URNLexicographicalComparator();

    public LoopingDatasetFinderSource(boolean drilldownIntoPartitions) {
        super(drilldownIntoPartitions);
    }

    @Override
    public List<WorkUnit> getWorkunits(SourceState state) {
        return Lists.newArrayList((Iterable)this.getWorkunitStream(state).getMaterializedWorkUnitCollection());
    }

    @Override
    public WorkUnitStream getWorkunitStream(SourceState state) {
        try {
            Optional maxWorkUnit;
            int maxWorkUnits = state.getPropAsInt(MAX_WORK_UNITS_PER_RUN_KEY, 10);
            List previousWorkUnitStates = state.getPreviousWorkUnitStates();
            try {
                maxWorkUnit = previousWorkUnitStates.stream().reduce((wu1, wu2) -> {
                    int wu2Ordinal;
                    int wu1Ordinal = wu1.getPropAsInt(WORK_UNIT_ORDINAL);
                    return wu1Ordinal > (wu2Ordinal = wu2.getPropAsInt(WORK_UNIT_ORDINAL)) ? wu1 : wu2;
                });
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("Work units in state store are corrupted! Missing or malformed gobblin.source.loopingDatasetFinderSource.workUnitOrdinal");
            }
            String previousDatasetUrnWatermark = null;
            String previousPartitionUrnWatermark = null;
            if (maxWorkUnit.isPresent() && !((WorkUnitState)maxWorkUnit.get()).getPropAsBoolean(END_OF_DATASETS_KEY, false)) {
                previousDatasetUrnWatermark = ((WorkUnitState)maxWorkUnit.get()).getProp(DATASET_URN);
                previousPartitionUrnWatermark = ((WorkUnitState)maxWorkUnit.get()).getProp(PARTITION_URN);
            }
            IterableDatasetFinder datasetsFinder = this.createDatasetsFinder(state);
            Stream datasetStream = datasetsFinder.getDatasetsStream(4, (Comparator)this.lexicographicalComparator);
            datasetStream = this.sortStreamLexicographically(datasetStream);
            return new BasicWorkUnitStream.Builder((Iterator)((Object)new DeepIterator(datasetStream.iterator(), previousDatasetUrnWatermark, previousPartitionUrnWatermark, maxWorkUnits))).setFiniteStream(true).build();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private <T extends URNIdentified> Stream<T> sortStreamLexicographically(Stream<T> inputStream) {
        Spliterator spliterator = inputStream.spliterator();
        if (spliterator.hasCharacteristics(4) && spliterator.getComparator().equals(this.lexicographicalComparator)) {
            return StreamSupport.stream(spliterator, false);
        }
        return StreamSupport.stream(spliterator, false).sorted(this.lexicographicalComparator);
    }

    private class DeepIterator
    extends AbstractIterator<WorkUnit> {
        private final Iterator<Dataset> baseIterator;
        private final int maxWorkUnits;
        private Iterator<PartitionableDataset.DatasetPartition> currentPartitionIterator;
        private int generatedWorkUnits = 0;

        public DeepIterator(Iterator<Dataset> baseIterator, String previousDatasetUrnWatermark, String previousPartitionUrnWatermark, int maxWorkUnits) {
            this.maxWorkUnits = maxWorkUnits;
            this.baseIterator = baseIterator;
            Dataset equalDataset = (Dataset)this.advanceUntilLargerThan(Iterators.peekingIterator(this.baseIterator), previousDatasetUrnWatermark);
            if (LoopingDatasetFinderSource.this.drilldownIntoPartitions && equalDataset != null && equalDataset instanceof PartitionableDataset) {
                this.currentPartitionIterator = this.getPartitionIterator((PartitionableDataset)equalDataset);
                this.advanceUntilLargerThan(Iterators.peekingIterator(this.currentPartitionIterator), previousPartitionUrnWatermark);
            } else {
                this.currentPartitionIterator = Iterators.emptyIterator();
            }
        }

        @Nullable
        private <T extends URNIdentified> T advanceUntilLargerThan(PeekingIterator<T> it, String reference) {
            if (reference == null) {
                return null;
            }
            int comparisonResult = -1;
            while (it.hasNext() && (comparisonResult = LoopingDatasetFinderSource.this.lexicographicalComparator.compare((URNIdentified)it.peek(), reference)) < 0) {
                it.next();
            }
            return (T)(comparisonResult == 0 ? (URNIdentified)it.next() : null);
        }

        private Iterator<PartitionableDataset.DatasetPartition> getPartitionIterator(PartitionableDataset dataset) {
            try {
                this.currentPartitionIterator = LoopingDatasetFinderSource.this.sortStreamLexicographically(dataset.getPartitions(4, (Comparator)LoopingDatasetFinderSource.this.lexicographicalComparator)).iterator();
                return this.currentPartitionIterator;
            }
            catch (IOException ioe) {
                log.error("Failed to get partitions for dataset " + dataset.getUrn());
                return Iterators.emptyIterator();
            }
        }

        protected WorkUnit computeNext() {
            if (this.generatedWorkUnits >= this.maxWorkUnits) {
                return (WorkUnit)this.endOfData();
            }
            while (this.baseIterator.hasNext() || this.currentPartitionIterator.hasNext()) {
                if (this.currentPartitionIterator != null && this.currentPartitionIterator.hasNext()) {
                    PartitionableDataset.DatasetPartition partition = this.currentPartitionIterator.next();
                    WorkUnit workUnit = LoopingDatasetFinderSource.this.workUnitForDatasetPartition(partition);
                    this.addDatasetInfoToWorkUnit(workUnit, partition.getDataset(), this.generatedWorkUnits++);
                    this.addPartitionInfoToWorkUnit(workUnit, partition);
                    return workUnit;
                }
                Dataset dataset = this.baseIterator.next();
                if (LoopingDatasetFinderSource.this.drilldownIntoPartitions && dataset instanceof PartitionableDataset) {
                    this.currentPartitionIterator = this.getPartitionIterator((PartitionableDataset)dataset);
                    continue;
                }
                WorkUnit workUnit = LoopingDatasetFinderSource.this.workUnitForDataset(dataset);
                this.addDatasetInfoToWorkUnit(workUnit, dataset, this.generatedWorkUnits++);
                return workUnit;
            }
            WorkUnit workUnit = NoopTask.noopWorkunit();
            workUnit.setProp(LoopingDatasetFinderSource.WORK_UNIT_ORDINAL, (Object)this.generatedWorkUnits);
            this.generatedWorkUnits = Integer.MAX_VALUE;
            workUnit.setProp(LoopingDatasetFinderSource.END_OF_DATASETS_KEY, (Object)true);
            return workUnit;
        }

        private void addDatasetInfoToWorkUnit(WorkUnit workUnit, Dataset dataset, int workUnitOrdinal) {
            workUnit.setProp(LoopingDatasetFinderSource.DATASET_URN, (Object)dataset.getUrn());
            workUnit.setProp(LoopingDatasetFinderSource.WORK_UNIT_ORDINAL, (Object)workUnitOrdinal);
        }

        private void addPartitionInfoToWorkUnit(WorkUnit workUnit, PartitionableDataset.DatasetPartition partition) {
            workUnit.setProp(LoopingDatasetFinderSource.PARTITION_URN, (Object)partition.getUrn());
        }
    }
}

