/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.policy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.data.management.retention.policy.RetentionPolicy;
import org.apache.gobblin.data.management.version.DatasetVersion;
import org.apache.gobblin.data.management.version.TimestampedDatasetVersion;
import org.apache.gobblin.util.ConfigUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBasedRetentionPolicy
implements RetentionPolicy<TimestampedDatasetVersion> {
    private static final Logger log = LoggerFactory.getLogger(TimeBasedRetentionPolicy.class);
    public static final String RETENTION_MINUTES_KEY = "gobblin.retention.minutes.retained";
    public static final String RETENTION_TIMEBASED_DURATION_KEY = "gobblin.retention.timebased.duration";
    private final Duration retention;

    public TimeBasedRetentionPolicy(Properties props) {
        this(ConfigUtils.propertiesToConfig((Properties)props));
    }

    public TimeBasedRetentionPolicy(Config config) {
        this.retention = TimeBasedRetentionPolicy.getDuration(config);
        log.info(String.format("%s will delete dataset versions older than %s.", TimeBasedRetentionPolicy.class.getName(), this.retention.toString()));
    }

    public TimeBasedRetentionPolicy(String duration) {
        this.retention = TimeBasedRetentionPolicy.parseDuration(duration);
        log.info(String.format("%s will delete dataset versions older than %s.", TimeBasedRetentionPolicy.class.getName(), duration));
    }

    @Override
    public Class<? extends DatasetVersion> versionClass() {
        return TimestampedDatasetVersion.class;
    }

    @Override
    public Collection<TimestampedDatasetVersion> listDeletableVersions(List<TimestampedDatasetVersion> allVersions) {
        return Lists.newArrayList((Iterable)Collections2.filter(allVersions, (Predicate)new Predicate<DatasetVersion>(){

            public boolean apply(DatasetVersion version) {
                return ((TimestampedDatasetVersion)version).getDateTime().plus((ReadableDuration)TimeBasedRetentionPolicy.this.retention).isBeforeNow();
            }
        }));
    }

    private static Duration parseDuration(String periodString) {
        DateTime zeroEpoc = new DateTime(0L);
        return new Duration((ReadableInstant)zeroEpoc, (ReadableInstant)zeroEpoc.plus((ReadablePeriod)ISOPeriodFormat.standard().parsePeriod(periodString)));
    }

    private static Duration getDuration(Config config) {
        Preconditions.checkArgument((config.hasPath(RETENTION_TIMEBASED_DURATION_KEY) || config.hasPath(RETENTION_MINUTES_KEY) ? 1 : 0) != 0, (Object)String.format("Either %s or %s needs to be set", RETENTION_TIMEBASED_DURATION_KEY, RETENTION_MINUTES_KEY));
        if (config.hasPath(RETENTION_TIMEBASED_DURATION_KEY)) {
            return TimeBasedRetentionPolicy.parseDuration(config.getString(RETENTION_TIMEBASED_DURATION_KEY));
        }
        return Duration.standardMinutes((long)Long.parseLong(config.getString(RETENTION_MINUTES_KEY)));
    }
}

