/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.policy;

import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.data.management.retention.policy.RetentionPolicy;
import org.apache.gobblin.data.management.version.DatasetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewestKRetentionPolicy<T extends DatasetVersion>
implements RetentionPolicy<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewestKRetentionPolicy.class);
    @Deprecated
    public static final String VERSIONS_RETAINED_KEY = "gobblin.retention.versions.retained";
    public static final String NEWEST_K_VERSIONS_RETAINED_KEY = "gobblin.retention.newestK.versions.retained";
    public static final String VERSIONS_RETAINED_DEFAULT = Integer.toString(2);
    private final int versionsRetained;

    public NewestKRetentionPolicy(int versionsRetained) {
        this.versionsRetained = versionsRetained;
        LOGGER.info(String.format("%s will retain %d versions of each dataset.", NewestKRetentionPolicy.class.getName(), this.versionsRetained));
    }

    public NewestKRetentionPolicy(Properties props) {
        this.versionsRetained = props.containsKey(VERSIONS_RETAINED_KEY) ? Integer.parseInt(props.getProperty(VERSIONS_RETAINED_KEY)) : (props.containsKey(NEWEST_K_VERSIONS_RETAINED_KEY) ? Integer.parseInt(props.getProperty(NEWEST_K_VERSIONS_RETAINED_KEY)) : Integer.parseInt(VERSIONS_RETAINED_DEFAULT));
    }

    public NewestKRetentionPolicy(Config config) {
        this(Integer.parseInt(config.getString(NEWEST_K_VERSIONS_RETAINED_KEY)));
    }

    @Override
    public Class<? extends DatasetVersion> versionClass() {
        return DatasetVersion.class;
    }

    @Override
    public Collection<T> listDeletableVersions(List<T> allVersions) {
        int newerVersions = 0;
        ArrayList deletableVersions = Lists.newArrayList();
        for (DatasetVersion datasetVersion : allVersions) {
            if (newerVersions >= this.versionsRetained) {
                deletableVersions.add(datasetVersion);
            }
            ++newerVersions;
        }
        return deletableVersions;
    }
}

