/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.dataset;

import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.data.management.retention.dataset.CleanableDatasetBase;
import org.apache.gobblin.data.management.retention.policy.NewestKRetentionPolicy;
import org.apache.gobblin.data.management.retention.policy.RetentionPolicy;
import org.apache.gobblin.data.management.retention.version.StringDatasetVersion;
import org.apache.gobblin.data.management.retention.version.finder.VersionFinder;
import org.apache.gobblin.data.management.retention.version.finder.WatermarkDatasetVersionFinder;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotDataset
extends CleanableDatasetBase<FileSystemDatasetVersion> {
    private final VersionFinder<StringDatasetVersion> versionFinder;
    private final RetentionPolicy<FileSystemDatasetVersion> retentionPolicy;
    private final Path datasetRoot;

    public SnapshotDataset(FileSystem fs, Properties props, Path datasetRoot) throws IOException {
        this(fs, props, datasetRoot, LoggerFactory.getLogger(SnapshotDataset.class));
    }

    public SnapshotDataset(FileSystem fs, Properties props, Path datasetRoot, Logger log) throws IOException {
        super(fs, props, log);
        this.datasetRoot = datasetRoot;
        this.versionFinder = new WatermarkDatasetVersionFinder(fs, props);
        this.retentionPolicy = new NewestKRetentionPolicy<FileSystemDatasetVersion>(props);
    }

    @Override
    public VersionFinder<? extends FileSystemDatasetVersion> getVersionFinder() {
        return this.versionFinder;
    }

    @Override
    public RetentionPolicy<FileSystemDatasetVersion> getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public Path datasetRoot() {
        return this.datasetRoot;
    }
}

