/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.dataset;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.data.management.policy.SelectNothingPolicy;
import org.apache.gobblin.data.management.policy.VersionSelectionPolicy;
import org.apache.gobblin.data.management.retention.action.MultiAccessControlAction;
import org.apache.gobblin.data.management.retention.action.RetentionAction;
import org.apache.gobblin.data.management.retention.dataset.MultiVersionCleanableDatasetBase;
import org.apache.gobblin.data.management.retention.policy.RetentionPolicy;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.finder.VersionFinder;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableCleanableDataset<T extends FileSystemDatasetVersion>
extends MultiVersionCleanableDatasetBase<T> {
    public static final String RETENTION_CONFIGURATION_KEY = "gobblin.retention";
    public static final String CONFIGURATION_KEY_PREFIX = "gobblin.retention.";
    public static final String VERSION_FINDER_CLASS_KEY = "gobblin.retention.version.finder.class";
    public static final String RETENTION_POLICY_CLASS_KEY = "gobblin.retention.retention.policy.class";
    public static final String SELECTION_POLICY_CLASS_KEY = "gobblin.retention.selection.policy.class";
    public static final String DATASET_PARTITIONS_LIST_KEY = "gobblin.retention.dataset.partitions";
    public static final String DATASET_VERSION_POLICY_ALIAS = "gobblin.retention.versionAndPolicy.alias";
    private final Path datasetRoot;
    private final List<MultiVersionCleanableDatasetBase.VersionFinderAndPolicy<T>> versionFindersAndPolicies;
    private static final Set<Class<? extends RetentionAction.RetentionActionFactory>> RETENTION_ACTION_TYPES = ImmutableSet.of(MultiAccessControlAction.MultiAccessControlActionFactory.class);

    public ConfigurableCleanableDataset(FileSystem fs, Properties jobProps, Path datasetRoot, Config config, Logger log) throws IOException {
        super(fs, jobProps, config, log);
        this.datasetRoot = datasetRoot;
        this.versionFindersAndPolicies = Lists.newArrayList();
        if (config.hasPath(DATASET_VERSION_POLICY_ALIAS)) {
            this.initWithSelectionPolicy(config.getConfig(DATASET_VERSION_POLICY_ALIAS), jobProps);
        } else if (config.hasPath(VERSION_FINDER_CLASS_KEY) && config.hasPath(RETENTION_POLICY_CLASS_KEY)) {
            this.initWithRetentionPolicy(config, jobProps, RETENTION_POLICY_CLASS_KEY, VERSION_FINDER_CLASS_KEY);
        } else if (config.hasPath(VERSION_FINDER_CLASS_KEY)) {
            this.initWithSelectionPolicy(config.getConfig(RETENTION_CONFIGURATION_KEY), jobProps);
        } else if (config.hasPath(DATASET_PARTITIONS_LIST_KEY)) {
            List versionAndPolicies = config.getConfigList(DATASET_PARTITIONS_LIST_KEY);
            for (Config versionAndPolicy : versionAndPolicies) {
                this.initWithSelectionPolicy(versionAndPolicy, jobProps);
            }
        } else {
            throw new IllegalArgumentException(String.format("Either set version finder at %s and retention policy at %s or set partitions at %s", VERSION_FINDER_CLASS_KEY, RETENTION_POLICY_CLASS_KEY, DATASET_PARTITIONS_LIST_KEY));
        }
    }

    public ConfigurableCleanableDataset(FileSystem fs, Properties props, Path datasetRoot) throws IOException {
        this(fs, props, datasetRoot, LoggerFactory.getLogger(ConfigurableCleanableDataset.class));
    }

    public ConfigurableCleanableDataset(FileSystem fs, Properties props, Path datasetRoot, Logger log) throws IOException {
        this(fs, props, datasetRoot, ConfigFactory.parseProperties((Properties)props), log);
    }

    public Path datasetRoot() {
        return this.datasetRoot;
    }

    @Override
    public List<MultiVersionCleanableDatasetBase.VersionFinderAndPolicy<T>> getVersionFindersAndPolicies() {
        return this.versionFindersAndPolicies;
    }

    private void initWithRetentionPolicy(Config config, Properties jobProps, String retentionPolicyKey, String versionFinderKey) {
        this.versionFindersAndPolicies.add(new MultiVersionCleanableDatasetBase.VersionFinderAndPolicy<T>(this.createRetentionPolicy(config.getString(retentionPolicyKey), config, jobProps), this.createVersionFinder(config.getString(versionFinderKey), config, jobProps)));
    }

    private void initWithSelectionPolicy(Config config, Properties jobProps) {
        String selectionPolicyKey = StringUtils.substringAfter((String)SELECTION_POLICY_CLASS_KEY, (String)CONFIGURATION_KEY_PREFIX);
        String versionFinderKey = StringUtils.substringAfter((String)VERSION_FINDER_CLASS_KEY, (String)CONFIGURATION_KEY_PREFIX);
        Preconditions.checkArgument((boolean)config.hasPath(versionFinderKey), (Object)String.format("Version finder class is required at %s in config %s", versionFinderKey, config.root().render(ConfigRenderOptions.concise())));
        MultiVersionCleanableDatasetBase.VersionFinderAndPolicy.VersionFinderAndPolicyBuilder<T> builder = MultiVersionCleanableDatasetBase.VersionFinderAndPolicy.builder();
        builder.versionFinder(this.createVersionFinder(config.getString(versionFinderKey), config, jobProps));
        if (config.hasPath(selectionPolicyKey)) {
            builder.versionSelectionPolicy(this.createSelectionPolicy(ConfigUtils.getString((Config)config, (String)selectionPolicyKey, (String)SelectNothingPolicy.class.getName()), config, jobProps));
        }
        for (Class<? extends RetentionAction.RetentionActionFactory> factoryClass : RETENTION_ACTION_TYPES) {
            try {
                RetentionAction.RetentionActionFactory factory = factoryClass.newInstance();
                if (!factory.canCreateWithConfig(config)) continue;
                builder.retentionAction(factory.createRetentionAction(config, this.fs, ConfigUtils.propertiesToConfig((Properties)jobProps)));
            }
            catch (IllegalAccessException | InstantiationException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        this.versionFindersAndPolicies.add(builder.build());
    }

    private VersionFinder<? extends T> createVersionFinder(String className, Config config, Properties jobProps) {
        try {
            return (VersionFinder)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(className), (List[])new List[]{ImmutableList.of((Object)this.fs, (Object)config), ImmutableList.of((Object)this.fs, (Object)jobProps)});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private RetentionPolicy<T> createRetentionPolicy(String className, Config config, Properties jobProps) {
        try {
            return (RetentionPolicy)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(className), (List[])new List[]{ImmutableList.of((Object)config), ImmutableList.of((Object)config, (Object)jobProps), ImmutableList.of((Object)jobProps)});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private VersionSelectionPolicy<T> createSelectionPolicy(String className, Config config, Properties jobProps) {
        try {
            this.log.debug(String.format("Configuring selection policy %s for %s with %s", className, this.datasetRoot, config.root().render(ConfigRenderOptions.concise())));
            return (VersionSelectionPolicy)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(className), (List[])new List[]{ImmutableList.of((Object)config), ImmutableList.of((Object)config, (Object)jobProps), ImmutableList.of((Object)jobProps)});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

