/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.action;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.data.management.policy.VersionSelectionPolicy;
import org.apache.gobblin.data.management.retention.dataset.FsCleanableHelper;
import org.apache.gobblin.data.management.version.DatasetVersion;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.fs.FileSystem;

public abstract class RetentionAction {
    protected final FileSystem fs;
    protected final ClassAliasResolver<VersionSelectionPolicy> versionSelectionAliasResolver = new ClassAliasResolver(VersionSelectionPolicy.class);
    protected final boolean isSimulateMode;

    public RetentionAction(Config actionConfig, FileSystem fs, Config jobConfig) {
        this.fs = fs;
        this.isSimulateMode = ConfigUtils.getBoolean((Config)jobConfig, (String)"gobblin.retention.simulate", (boolean)Boolean.valueOf(FsCleanableHelper.SIMULATE_DEFAULT));
    }

    public abstract void execute(List<DatasetVersion> var1) throws IOException;

    protected VersionSelectionPolicy<DatasetVersion> createSelectionPolicy(Config selectionConfig, Config jobConfig) {
        try {
            String selectionPolicyKey = StringUtils.substringAfter((String)"gobblin.retention.selection.policy.class", (String)"gobblin.retention.");
            Preconditions.checkArgument((boolean)selectionConfig.hasPath(selectionPolicyKey));
            String className = selectionConfig.getString(selectionPolicyKey);
            return (VersionSelectionPolicy)GobblinConstructorUtils.invokeFirstConstructor((Class)this.versionSelectionAliasResolver.resolveClass(className), (List[])new List[]{ImmutableList.of((Object)selectionConfig), ImmutableList.of((Object)selectionConfig, (Object)ConfigUtils.configToProperties((Config)jobConfig)), ImmutableList.of((Object)ConfigUtils.configToProperties((Config)jobConfig))});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static interface RetentionActionFactory {
        public RetentionAction createRetentionAction(Config var1, FileSystem var2, Config var3);

        public boolean canCreateWithConfig(Config var1);
    }
}

