/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.data.management.copy.replication.CopyRoute;
import org.apache.gobblin.data.management.copy.replication.CopyRouteGenerator;
import org.apache.gobblin.data.management.copy.replication.CopyRouteGeneratorOptimizedNetworkBandwidth;
import org.apache.gobblin.data.management.copy.replication.DataFlowTopology;
import org.apache.gobblin.data.management.copy.replication.DataFlowTopologyPickerByHadoopFsSource;
import org.apache.gobblin.data.management.copy.replication.DataFlowTopologyPickerBySource;
import org.apache.gobblin.data.management.copy.replication.EndPoint;
import org.apache.gobblin.data.management.copy.replication.EndPointFactory;
import org.apache.gobblin.data.management.copy.replication.HadoopFsEndPointFactory;
import org.apache.gobblin.data.management.copy.replication.ReplicationCopyMode;
import org.apache.gobblin.data.management.copy.replication.ReplicationMetaData;
import org.apache.gobblin.util.ClassAliasResolver;

public class ReplicationConfiguration {
    public static final String REPLICATION_COPY_MODE = "copymode";
    public static final String METADATA = "metadata";
    public static final String METADATA_JIRA = "jira";
    public static final String METADATA_OWNER = "owner";
    public static final String METADATA_NAME = "name";
    public static final String REPLICATION_SOURCE = "source";
    public static final String REPLICATION_REPLICAS = "replicas";
    public static final String REPLICATOIN_REPLICAS_LIST = "list";
    public static final String DATA_FLOW_TOPOLOGY = "dataFlowTopology";
    public static final String DATA_FLOW_TOPOLOGY_ROUTES = "routes";
    public static final String DEFAULT_DATA_FLOW_TOPOLOGIES_PUSHMODE = "defaultDataFlowTopologies_PushMode";
    public static final String DEFAULT_DATA_FLOW_TOPOLOGIES_PULLMODE = "defaultDataFlowTopologies_PullMode";
    public static final String REPLICATION_DATA_CATETORY_TYPE = "replicationDataCategoryType";
    public static final String REPLICATION_DATA_FINITE_INSTANCE = "replicationDataFiniteInstance";
    public static final String DELETE_TARGET_IFNOT_ON_SOURCE = "deleteTarget";
    public static final String DATA_FLOW_TOPOLOGY_PICKER_CLASS = "dataFlowTopologyPickerClass";
    public static final String DEFAULT_DATA_FLOW_TOPOLOGY_PICKER_CLASS = DataFlowTopologyPickerByHadoopFsSource.class.getCanonicalName();
    public static final ClassAliasResolver<DataFlowTopologyPickerBySource> dataFlowTopologyPickerResolver = new ClassAliasResolver(DataFlowTopologyPickerBySource.class);
    public static final String END_POINT_FACTORY_CLASS = "endPointFactoryClass";
    public static final String DEFAULT_END_POINT_FACTORY_CLASS = HadoopFsEndPointFactory.class.getCanonicalName();
    public static final ClassAliasResolver<EndPointFactory> endPointFactoryResolver = new ClassAliasResolver(EndPointFactory.class);
    public static final String COPYROUTE_OPTIMIZER_CLASS = "copyRouteOptimizerClass";
    public static final String DEFAULT_COPYROUTE_OPTIMIZER_CLASS = CopyRouteGeneratorOptimizedNetworkBandwidth.class.getCanonicalName();
    public static final ClassAliasResolver<CopyRouteGenerator> copyRouteGeneratorResolver = new ClassAliasResolver(CopyRouteGenerator.class);
    private final ReplicationCopyMode copyMode;
    private final Config selectionConfig;
    private final ReplicationMetaData metaData;
    private final EndPoint source;
    private final List<EndPoint> replicas;
    private final DataFlowTopology dataFlowToplogy;
    private final CopyRouteGenerator copyRouteGenerator;
    private final boolean deleteTargetIfNotExistOnSource;

    public static ReplicationConfiguration buildFromConfig(Config input) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"can not build ReplicationConfig from null");
        Config config = input.resolve();
        return new Builder().withReplicationMetaData(ReplicationMetaData.buildMetaData(config)).withReplicationCopyMode(ReplicationCopyMode.getReplicationCopyMode(config)).withSelectionConfig(config.getConfig("gobblin.selected.policy")).withReplicationSource(config).withReplicationReplica(config).withDefaultDataFlowTopologyConfig_PullMode(config).withDefaultDataFlowTopologyConfig_PushMode(config).withDataFlowTopologyConfig(config).withCopyRouteGenerator(config).withDeleteTarget(config).build();
    }

    private ReplicationConfiguration(Builder builder) {
        this.metaData = builder.metaData;
        this.source = builder.source;
        this.replicas = builder.replicas;
        this.copyMode = builder.copyMode;
        this.selectionConfig = builder.selectionConfig;
        this.dataFlowToplogy = builder.dataFlowTopology;
        this.copyRouteGenerator = builder.copyRouteGenerator;
        this.deleteTargetIfNotExistOnSource = builder.deleteTargetIfNotExistOnSource;
    }

    public ReplicationCopyMode getCopyMode() {
        return this.copyMode;
    }

    public Config getSelectionConfig() {
        return this.selectionConfig;
    }

    public ReplicationMetaData getMetaData() {
        return this.metaData;
    }

    public EndPoint getSource() {
        return this.source;
    }

    public List<EndPoint> getReplicas() {
        return this.replicas;
    }

    public DataFlowTopology getDataFlowToplogy() {
        return this.dataFlowToplogy;
    }

    public CopyRouteGenerator getCopyRouteGenerator() {
        return this.copyRouteGenerator;
    }

    public boolean isDeleteTargetIfNotExistOnSource() {
        return this.deleteTargetIfNotExistOnSource;
    }

    private static class Builder {
        private ReplicationMetaData metaData;
        private EndPoint source;
        private List<EndPoint> replicas = new ArrayList<EndPoint>();
        private ReplicationCopyMode copyMode;
        private Config selectionConfig;
        private Config dataFlowTopologyConfig;
        private Optional<Config> defaultDataFlowTopology_PushModeConfig;
        private Optional<Config> defaultDataFlowTopology_PullModeConfig;
        private DataFlowTopology dataFlowTopology = new DataFlowTopology();
        private CopyRouteGenerator copyRouteGenerator;
        private boolean deleteTargetIfNotExistOnSource = false;

        private Builder() {
        }

        public Builder withReplicationMetaData(ReplicationMetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder withDeleteTarget(Config config) {
            if (config.hasPath(ReplicationConfiguration.DELETE_TARGET_IFNOT_ON_SOURCE)) {
                this.deleteTargetIfNotExistOnSource = config.getBoolean(ReplicationConfiguration.DELETE_TARGET_IFNOT_ON_SOURCE);
            }
            return this;
        }

        public Builder withCopyRouteGenerator(Config config) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            String copyRouteGeneratorStr = config.hasPath(ReplicationConfiguration.COPYROUTE_OPTIMIZER_CLASS) ? config.getString(ReplicationConfiguration.COPYROUTE_OPTIMIZER_CLASS) : DEFAULT_COPYROUTE_OPTIMIZER_CLASS;
            this.copyRouteGenerator = (CopyRouteGenerator)copyRouteGeneratorResolver.resolveClass(copyRouteGeneratorStr).newInstance();
            return this;
        }

        public Builder withReplicationSource(Config config) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            Preconditions.checkArgument((boolean)config.hasPath(ReplicationConfiguration.REPLICATION_SOURCE), (Object)"missing required config entry source");
            Config sourceConfig = config.getConfig(ReplicationConfiguration.REPLICATION_SOURCE);
            String endPointFactory = sourceConfig.hasPath(ReplicationConfiguration.END_POINT_FACTORY_CLASS) ? sourceConfig.getString(ReplicationConfiguration.END_POINT_FACTORY_CLASS) : DEFAULT_END_POINT_FACTORY_CLASS;
            EndPointFactory factory = (EndPointFactory)endPointFactoryResolver.resolveClass(endPointFactory).newInstance();
            this.source = factory.buildSource(sourceConfig, this.selectionConfig);
            return this;
        }

        public Builder withReplicationReplica(Config config) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            Preconditions.checkArgument((boolean)config.hasPath(ReplicationConfiguration.REPLICATION_REPLICAS), (Object)"missing required config entery replicas");
            Config replicasConfig = config.getConfig(ReplicationConfiguration.REPLICATION_REPLICAS);
            Preconditions.checkArgument((boolean)replicasConfig.hasPath(ReplicationConfiguration.REPLICATOIN_REPLICAS_LIST), (Object)"missing required config entery list");
            List replicaNames = replicasConfig.getStringList(ReplicationConfiguration.REPLICATOIN_REPLICAS_LIST);
            for (String replicaName : replicaNames) {
                Preconditions.checkArgument((boolean)replicasConfig.hasPath(replicaName), (Object)("missing replica name " + replicaName));
                Config subConfig = replicasConfig.getConfig(replicaName);
                String endPointFactory = subConfig.hasPath(ReplicationConfiguration.END_POINT_FACTORY_CLASS) ? subConfig.getString(ReplicationConfiguration.END_POINT_FACTORY_CLASS) : DEFAULT_END_POINT_FACTORY_CLASS;
                EndPointFactory factory = (EndPointFactory)endPointFactoryResolver.resolveClass(endPointFactory).newInstance();
                this.replicas.add(factory.buildReplica(subConfig, replicaName, this.selectionConfig));
            }
            return this;
        }

        public Builder withDataFlowTopologyConfig(Config config) {
            Preconditions.checkArgument((boolean)config.hasPath(ReplicationConfiguration.DATA_FLOW_TOPOLOGY), (Object)"missing required config entery dataFlowTopology");
            this.dataFlowTopologyConfig = config.getConfig(ReplicationConfiguration.DATA_FLOW_TOPOLOGY);
            return this;
        }

        public Builder withDefaultDataFlowTopologyConfig_PushMode(Config config) {
            this.defaultDataFlowTopology_PushModeConfig = config.hasPath(ReplicationConfiguration.DEFAULT_DATA_FLOW_TOPOLOGIES_PUSHMODE) ? Optional.of((Object)config.getConfig(ReplicationConfiguration.DEFAULT_DATA_FLOW_TOPOLOGIES_PUSHMODE)) : Optional.absent();
            return this;
        }

        public Builder withDefaultDataFlowTopologyConfig_PullMode(Config config) {
            this.defaultDataFlowTopology_PullModeConfig = config.hasPath(ReplicationConfiguration.DEFAULT_DATA_FLOW_TOPOLOGIES_PULLMODE) ? Optional.of((Object)config.getConfig(ReplicationConfiguration.DEFAULT_DATA_FLOW_TOPOLOGIES_PULLMODE)) : Optional.absent();
            return this;
        }

        public Builder withReplicationCopyMode(ReplicationCopyMode copyMode) {
            this.copyMode = copyMode;
            return this;
        }

        public Builder withSelectionConfig(Config selectionConfig) {
            this.selectionConfig = selectionConfig;
            return this;
        }

        private void constructDataFlowTopology() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            if (this.dataFlowTopologyConfig.hasPath(ReplicationConfiguration.DATA_FLOW_TOPOLOGY_ROUTES)) {
                Config routesConfig = this.dataFlowTopologyConfig.getConfig(ReplicationConfiguration.DATA_FLOW_TOPOLOGY_ROUTES);
                this.constructDataFlowTopologyWithConfig(routesConfig);
                return;
            }
            String topologyPickerStr = this.dataFlowTopologyConfig.hasPath(ReplicationConfiguration.DATA_FLOW_TOPOLOGY_PICKER_CLASS) ? this.dataFlowTopologyConfig.getString(ReplicationConfiguration.DATA_FLOW_TOPOLOGY_PICKER_CLASS) : DEFAULT_DATA_FLOW_TOPOLOGY_PICKER_CLASS;
            DataFlowTopologyPickerBySource picker = (DataFlowTopologyPickerBySource)dataFlowTopologyPickerResolver.resolveClass(topologyPickerStr).newInstance();
            if (this.copyMode == ReplicationCopyMode.PULL) {
                Preconditions.checkArgument((boolean)this.defaultDataFlowTopology_PullModeConfig.isPresent(), (Object)"No topology to pick in pull mode");
                Config preferredTopology = picker.getPreferredRoutes((Config)this.defaultDataFlowTopology_PullModeConfig.get(), this.source);
                Config routesConfig = preferredTopology.getConfig(ReplicationConfiguration.DATA_FLOW_TOPOLOGY_ROUTES);
                this.constructDataFlowTopologyWithConfig(routesConfig);
            } else {
                Preconditions.checkArgument((boolean)this.defaultDataFlowTopology_PushModeConfig.isPresent(), (Object)"No topology to pick in push mode");
                Config preferredTopology = picker.getPreferredRoutes((Config)this.defaultDataFlowTopology_PushModeConfig.get(), this.source);
                Config routesConfig = preferredTopology.getConfig(ReplicationConfiguration.DATA_FLOW_TOPOLOGY_ROUTES);
                this.constructDataFlowTopologyWithConfig(routesConfig);
            }
        }

        private void constructDataFlowTopologyWithConfig(Config routesConfig) {
            Preconditions.checkArgument((routesConfig != null && !routesConfig.isEmpty() ? 1 : 0) != 0, (Object)"Can not build topology without empty config");
            Preconditions.checkArgument((this.source != null ? 1 : 0) != 0, (Object)"Can not build topology without source");
            Preconditions.checkArgument((this.replicas.size() != 0 ? 1 : 0) != 0, (Object)"Can not build topology without replicas");
            final HashMap<String, EndPoint> validEndPoints = new HashMap<String, EndPoint>();
            validEndPoints.put(this.source.getEndPointName(), this.source);
            for (EndPoint p : this.replicas) {
                validEndPoints.put(p.getEndPointName(), p);
            }
            if (this.copyMode == ReplicationCopyMode.PULL) {
                for (final EndPoint replica : this.replicas) {
                    Preconditions.checkArgument((boolean)routesConfig.hasPath(replica.getEndPointName()), (Object)("Can not find the pull flow for replia " + replica.getEndPointName()));
                    List copyFromStringsRaw = routesConfig.getStringList(replica.getEndPointName());
                    ArrayList<String> copyFromStrings = new ArrayList<String>();
                    for (String s : copyFromStringsRaw) {
                        if (!validEndPoints.containsKey(s)) continue;
                        copyFromStrings.add(s);
                    }
                    List copyPairs = Lists.transform(copyFromStrings, (Function)new Function<String, CopyRoute>(){

                        public CopyRoute apply(String t) {
                            return new CopyRoute((EndPoint)validEndPoints.get(t), replica);
                        }
                    });
                    DataFlowTopology.DataFlowPath dataFlowPath = new DataFlowTopology.DataFlowPath(copyPairs);
                    this.dataFlowTopology.addDataFlowPath(dataFlowPath);
                }
            } else {
                HashSet currentCopyTo = new HashSet();
                for (final Map.Entry valid : validEndPoints.entrySet()) {
                    if (!routesConfig.hasPath((String)valid.getKey())) continue;
                    List copyToStringsRaw = routesConfig.getStringList((String)valid.getKey());
                    ArrayList<String> copyToStrings = new ArrayList<String>();
                    for (String s : copyToStringsRaw) {
                        if (s.equals(this.source.getEndPointName()) || !validEndPoints.containsKey(s)) continue;
                        copyToStrings.add(s);
                    }
                    for (String s : copyToStrings) {
                        Preconditions.checkArgument((!currentCopyTo.contains(s) ? 1 : 0) != 0, (Object)("In Push mode, can not have multiple copies to " + s));
                    }
                    currentCopyTo.addAll(copyToStrings);
                    List copyPairs = Lists.transform(copyToStrings, (Function)new Function<String, CopyRoute>(){

                        public CopyRoute apply(String t) {
                            return new CopyRoute((EndPoint)valid.getValue(), (EndPoint)validEndPoints.get(t));
                        }
                    });
                    DataFlowTopology.DataFlowPath dataFlowPath = new DataFlowTopology.DataFlowPath(copyPairs);
                    this.dataFlowTopology.addDataFlowPath(dataFlowPath);
                }
                Preconditions.checkArgument((currentCopyTo.size() == this.replicas.size() ? 1 : 0) != 0, (Object)"Not all replicas have valid data flow in push mode");
            }
        }

        public ReplicationConfiguration build() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            this.constructDataFlowTopology();
            return new ReplicationConfiguration(this);
        }
    }
}

