/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.publisher;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopySource;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.publisher.CopyDataPublisher;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletingCopyDataPublisher
extends CopyDataPublisher {
    private static final Logger log = LoggerFactory.getLogger(DeletingCopyDataPublisher.class);
    private final FileSystem sourceFs;

    public DeletingCopyDataPublisher(State state) throws IOException {
        super(state);
        Configuration conf = HadoopUtils.getConfFromState((State)state);
        String uri = state.getProp("source.filebased.fs.uri", "file:///");
        this.sourceFs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
    }

    @Override
    public void publishData(Collection<? extends WorkUnitState> states) throws IOException {
        super.publishData(states);
        for (WorkUnitState workUnitState : states) {
            if (workUnitState.getWorkingState() == WorkUnitState.WorkingState.COMMITTED) {
                try {
                    this.deleteFilesOnSource(workUnitState);
                }
                catch (Throwable t) {
                    log.warn(String.format("Failed to delete one or more files on source in %s", workUnitState.getProp("gobblin.copy.serialized.copyable.file")), t);
                }
                continue;
            }
            log.info(String.format("Not deleting files %s on source fileSystem as the workunit state is %s.", workUnitState.getProp("gobblin.copy.serialized.copyable.file"), workUnitState.getWorkingState()));
        }
    }

    private void deleteFilesOnSource(WorkUnitState state) throws IOException {
        CopyEntity copyEntity = CopySource.deserializeCopyEntity((State)state);
        if (copyEntity instanceof CopyableFile) {
            HadoopUtils.deletePath((FileSystem)this.sourceFs, (Path)((CopyableFile)copyEntity).getOrigin().getPath(), (boolean)true);
            HadoopUtils.deletePath((FileSystem)this.sourceFs, (Path)PathUtils.addExtension((Path)((CopyableFile)copyEntity).getOrigin().getPath(), (String[])new String[]{".ready"}), (boolean)true);
        }
    }
}

