/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive.avro;

import com.google.common.base.Optional;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.data.management.copy.hive.HiveCopyEntityHelper;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAvroCopyEntityHelper {
    private static final Logger log = LoggerFactory.getLogger(HiveAvroCopyEntityHelper.class);
    private static final String HIVE_TABLE_AVRO_SCHEMA_URL = "avro.schema.url";

    public static void updateTableAttributesIfAvro(Table targetTable, HiveCopyEntityHelper hiveHelper) throws IOException {
        if (HiveAvroCopyEntityHelper.isHiveTableAvroType(targetTable)) {
            HiveAvroCopyEntityHelper.updateAvroSchemaURL(targetTable.getCompleteName(), targetTable.getTTable().getSd(), hiveHelper);
        }
    }

    public static void updatePartitionAttributesIfAvro(Table targetTable, Map<List<String>, Partition> sourcePartitions, HiveCopyEntityHelper hiveHelper) throws IOException {
        if (HiveAvroCopyEntityHelper.isHiveTableAvroType(targetTable)) {
            for (Map.Entry<List<String>, Partition> partition : sourcePartitions.entrySet()) {
                HiveAvroCopyEntityHelper.updateAvroSchemaURL(partition.getValue().getCompleteName(), partition.getValue().getTPartition().getSd(), hiveHelper);
            }
        }
    }

    public static void updateAvroSchemaURL(String entity, StorageDescriptor sd, HiveCopyEntityHelper hiveHelper) {
        String oldAvroSchemaURL = (String)sd.getSerdeInfo().getParameters().get(HIVE_TABLE_AVRO_SCHEMA_URL);
        if (oldAvroSchemaURL != null) {
            Path oldAvroSchemaPath = new Path(oldAvroSchemaURL);
            URI sourceFileSystemURI = hiveHelper.getDataset().getFs().getUri();
            if (PathUtils.isAbsoluteAndSchemeAuthorityNull((Path)oldAvroSchemaPath) || oldAvroSchemaPath.toUri().getScheme().equals(sourceFileSystemURI.getScheme()) && oldAvroSchemaPath.toUri().getAuthority().equals(sourceFileSystemURI.getAuthority())) {
                String newAvroSchemaURL = hiveHelper.getTargetPathHelper().getTargetPath(oldAvroSchemaPath, hiveHelper.getTargetFileSystem(), (Optional<Partition>)Optional.absent(), true).toString();
                sd.getSerdeInfo().getParameters().put(HIVE_TABLE_AVRO_SCHEMA_URL, newAvroSchemaURL);
                log.info(String.format("For entity %s, change %s from %s to %s", entity, HIVE_TABLE_AVRO_SCHEMA_URL, oldAvroSchemaURL, newAvroSchemaURL));
            }
        }
    }

    public static boolean isHiveTableAvroType(Table targetTable) throws IOException {
        String serializationLib = targetTable.getTTable().getSd().getSerdeInfo().getSerializationLib();
        String inputFormat = targetTable.getTTable().getSd().getInputFormat();
        String outputFormat = targetTable.getTTable().getSd().getOutputFormat();
        return inputFormat.endsWith("AvroContainerInputFormat") || outputFormat.endsWith("AvroContainerOutputFormat") || serializationLib.endsWith("AvroSerDe");
    }
}

