/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.gobblin.data.management.copy.CopyEntity;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.entities.PrePublishStep;
import org.apache.gobblin.data.management.copy.hive.HiveCopyEntityHelper;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.copy.hive.HiveFileSet;
import org.apache.gobblin.data.management.copy.hive.HiveLocationDescriptor;
import org.apache.gobblin.data.management.copy.hive.HiveTableLocationNotMatchException;
import org.apache.gobblin.metrics.event.MultiTimingEvent;
import org.apache.gobblin.util.commit.DeleteFileCommitStep;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpartitionedTableFileSet
extends HiveFileSet {
    private static final Logger log = LoggerFactory.getLogger(UnpartitionedTableFileSet.class);
    private final HiveCopyEntityHelper helper;

    public UnpartitionedTableFileSet(String name, HiveDataset dataset, HiveCopyEntityHelper helper) {
        super(name, dataset);
        this.helper = helper;
    }

    @Override
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    protected Collection<CopyEntity> generateCopyEntities() throws IOException {
        Optional existingTargetLocation;
        MultiTimingEvent multiTimer = new MultiTimingEvent(this.helper.getEventSubmitter(), "TableCopy", true);
        int stepPriority = 0;
        String fileSet = this.getTable().getTableName();
        ArrayList copyEntities = Lists.newArrayList();
        Optional existingTargetTable = this.helper.getExistingTargetTable();
        if (existingTargetTable.isPresent() && !this.helper.getTargetTable().getDataLocation().equals((Object)((Table)existingTargetTable.get()).getDataLocation())) {
            switch (this.helper.getExistingEntityPolicy()) {
                case UPDATE_TABLE: {
                    log.warn("Source table will not be deregistered while file locaiton has been changed, update source table's file location to" + this.helper.getTargetTable().getDataLocation());
                    existingTargetTable = Optional.absent();
                    break;
                }
                case REPLACE_TABLE: 
                case REPLACE_TABLE_AND_PARTITIONS: {
                    log.warn("Source and target table are not compatible. Will override target table " + ((Table)existingTargetTable.get()).getDataLocation());
                    stepPriority = this.helper.addTableDeregisterSteps(copyEntities, fileSet, stepPriority, this.helper.getTargetTable());
                    existingTargetTable = Optional.absent();
                    break;
                }
                default: {
                    log.error("Source and target table are not compatible. Aborting copy of table " + this.helper.getTargetTable(), (Throwable)new HiveTableLocationNotMatchException(this.helper.getTargetTable().getDataLocation(), ((Table)existingTargetTable.get()).getDataLocation()));
                    multiTimer.close();
                    return Lists.newArrayList();
                }
            }
        }
        stepPriority = this.helper.addSharedSteps(copyEntities, fileSet, stepPriority);
        HiveLocationDescriptor sourceLocation = HiveLocationDescriptor.forTable(this.getTable(), this.getHiveDataset().getFs(), this.getHiveDataset().getProperties());
        HiveLocationDescriptor desiredTargetLocation = HiveLocationDescriptor.forTable(this.helper.getTargetTable(), this.helper.getTargetFs(), this.getHiveDataset().getProperties());
        Optional optional = existingTargetLocation = existingTargetTable.isPresent() ? Optional.of((Object)HiveLocationDescriptor.forTable((Table)existingTargetTable.get(), this.helper.getTargetFs(), this.getHiveDataset().getProperties())) : Optional.absent();
        if (this.helper.getFastTableSkip().isPresent() && ((Predicate)this.helper.getFastTableSkip().get()).apply((Object)this.helper)) {
            log.info(String.format("Skipping copy of table %s due to fast table skip predicate.", this.getTable().getDbName() + "." + this.getTable().getTableName()));
            multiTimer.close();
            return Lists.newArrayList();
        }
        HiveCopyEntityHelper.DiffPathSet diffPathSet = HiveCopyEntityHelper.fullPathDiff(sourceLocation, desiredTargetLocation, (Optional<HiveLocationDescriptor>)existingTargetLocation, (Optional<Partition>)Optional.absent(), multiTimer, this.helper);
        multiTimer.nextStage("FullPathDiff");
        DeleteFileCommitStep deleteStep = DeleteFileCommitStep.fromPaths(this.helper.getTargetFs(), diffPathSet.pathsToDelete, this.getHiveDataset().getProperties());
        copyEntities.add(new PrePublishStep(fileSet, Maps.newHashMap(), deleteStep, stepPriority++));
        for (CopyableFile.Builder builder : this.helper.getCopyableFilesFromPaths(diffPathSet.filesToCopy, this.helper.getConfiguration(), (Optional<Partition>)Optional.absent())) {
            CopyableFile fileEntity = builder.fileSet(fileSet).datasetOutputPath(desiredTargetLocation.location.toString()).build();
            this.helper.setCopyableFileDatasets(fileEntity);
            copyEntities.add(fileEntity);
        }
        multiTimer.close();
        return copyEntities;
    }
}

