/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.gobblin.data.management.copy.CopyableFile;
import org.apache.gobblin.data.management.copy.CopyableFileFilter;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadyCopyableFileFilter
implements CopyableFileFilter {
    private static final Logger log = LoggerFactory.getLogger(ReadyCopyableFileFilter.class);
    public static final String READY_EXTENSION = ".ready";

    @Override
    public Collection<CopyableFile> filter(FileSystem sourceFs, FileSystem targetFs, Collection<CopyableFile> copyableFiles) {
        Iterator<CopyableFile> cfIterator = copyableFiles.iterator();
        ImmutableList.Builder filtered = ImmutableList.builder();
        while (cfIterator.hasNext()) {
            CopyableFile cf = cfIterator.next();
            Path readyFilePath = PathUtils.addExtension((Path)cf.getOrigin().getPath(), (String[])new String[]{READY_EXTENSION});
            try {
                if (sourceFs.exists(readyFilePath)) {
                    filtered.add((Object)cf);
                    continue;
                }
                log.info(String.format("Removing %s as the .ready file is not found", cf.getOrigin().getPath()));
            }
            catch (IOException e) {
                log.warn(String.format("Removing %s as the .ready file can not be read. Exception %s", cf.getOrigin().getPath(), e.getMessage()));
            }
        }
        return filtered.build();
    }
}

