/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.extractor;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.conversion.hive.avro.AvroSchemaManager;
import org.apache.gobblin.data.management.conversion.hive.dataset.ConvertibleHiveDataset;
import org.apache.gobblin.data.management.conversion.hive.entities.QueryBasedHiveConversionEntity;
import org.apache.gobblin.data.management.conversion.hive.entities.SchemaAwareHivePartition;
import org.apache.gobblin.data.management.conversion.hive.entities.SchemaAwareHiveTable;
import org.apache.gobblin.data.management.conversion.hive.extractor.HiveBaseExtractor;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveConvertExtractor
extends HiveBaseExtractor<Schema, QueryBasedHiveConversionEntity> {
    private static final Logger log = LoggerFactory.getLogger(HiveConvertExtractor.class);
    private List<QueryBasedHiveConversionEntity> conversionEntities = Lists.newArrayList();

    public HiveConvertExtractor(WorkUnitState state, FileSystem fs) throws IOException, TException, HiveException {
        super(state);
        if (Boolean.valueOf(state.getPropAsBoolean("hive.source.watermark.isWatermarkWorkUnit")).booleanValue()) {
            log.info("Ignoring Watermark workunit for {}", (Object)state.getProp("dataset.urn"));
            return;
        }
        if (!(this.hiveDataset instanceof ConvertibleHiveDataset)) {
            throw new IllegalStateException("HiveConvertExtractor is only compatible with ConvertibleHiveDataset");
        }
        ConvertibleHiveDataset convertibleHiveDataset = (ConvertibleHiveDataset)this.hiveDataset;
        try (AutoReturnableObject client = this.pool.getClient();){
            Table table = ((IMetaStoreClient)client.get()).getTable(this.dbName, this.tableName);
            SchemaAwareHiveTable schemaAwareHiveTable = new SchemaAwareHiveTable(table, AvroSchemaManager.getSchemaFromUrl(this.hiveWorkUnit.getTableSchemaUrl(), fs));
            SchemaAwareHivePartition schemaAwareHivePartition = null;
            if (this.hiveWorkUnit.getPartitionName().isPresent() && this.hiveWorkUnit.getPartitionSchemaUrl().isPresent()) {
                Partition partition = ((IMetaStoreClient)client.get()).getPartition(this.dbName, this.tableName, (String)this.hiveWorkUnit.getPartitionName().get());
                schemaAwareHivePartition = new SchemaAwareHivePartition(table, partition, AvroSchemaManager.getSchemaFromUrl((Path)this.hiveWorkUnit.getPartitionSchemaUrl().get(), fs));
            }
            QueryBasedHiveConversionEntity entity = new QueryBasedHiveConversionEntity(convertibleHiveDataset, schemaAwareHiveTable, (Optional<SchemaAwareHivePartition>)Optional.fromNullable(schemaAwareHivePartition));
            this.conversionEntities.add(entity);
        }
    }

    public Schema getSchema() throws IOException {
        if (this.conversionEntities.isEmpty()) {
            return Schema.create((Schema.Type)Schema.Type.NULL);
        }
        QueryBasedHiveConversionEntity conversionEntity = this.conversionEntities.get(0);
        return conversionEntity.getHiveTable().getAvroSchema();
    }

    public QueryBasedHiveConversionEntity readRecord(QueryBasedHiveConversionEntity reuse) throws DataRecordException, IOException {
        if (this.conversionEntities.isEmpty()) {
            return null;
        }
        return this.conversionEntities.remove(0);
    }
}

