/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.objectstore;

import com.codahale.metrics.Counter;
import java.io.IOException;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.writer.InstrumentedDataWriter;
import org.apache.gobblin.writer.objectstore.ObjectStoreClient;
import org.apache.gobblin.writer.objectstore.ObjectStoreOperation;

@Alpha
public class ObjectStoreWriter
extends InstrumentedDataWriter<ObjectStoreOperation> {
    private static final String OPERATIONS_EXECUTED_COUNTER = "gobblin.objectStoreWriter.operationsExecuted";
    private final Counter operationsExecuted;
    private final ObjectStoreClient objectStoreClient;

    public ObjectStoreWriter(ObjectStoreClient client, State state) {
        super(state);
        this.objectStoreClient = client;
        this.operationsExecuted = this.getMetricContext().counter(OPERATIONS_EXECUTED_COUNTER);
    }

    public void close() throws IOException {
        this.objectStoreClient.close();
    }

    public void writeImpl(ObjectStoreOperation operation) throws IOException {
        operation.execute(this.getObjectStoreClient());
        this.operationsExecuted.inc();
    }

    public void commit() throws IOException {
    }

    public void cleanup() throws IOException {
        this.getObjectStoreClient().close();
    }

    public long recordsWritten() {
        return this.operationsExecuted.getCount();
    }

    public long bytesWritten() throws IOException {
        return 0L;
    }

    public ObjectStoreClient getObjectStoreClient() {
        return this.objectStoreClient;
    }
}

