/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.writer.FsDataWriter;
import org.apache.gobblin.writer.SimpleDataWriterBuilder;

public class SimpleDataWriter
extends FsDataWriter<byte[]> {
    private final Optional<Byte> recordDelimiter;
    private final boolean prependSize;
    private int recordsWritten;
    private int bytesWritten;
    private final OutputStream stagingFileOutputStream;

    public SimpleDataWriter(SimpleDataWriterBuilder builder, State properties) throws IOException {
        super(builder, properties);
        String delim = properties.getProp("simple.writer.delimiter", null);
        this.recordDelimiter = delim == null || delim.length() == 0 ? Optional.absent() : Optional.of((Object)delim.getBytes(ConfigurationKeys.DEFAULT_CHARSET_ENCODING)[0]);
        this.prependSize = properties.getPropAsBoolean("simple.writer.prepend.size", false);
        this.recordsWritten = 0;
        this.bytesWritten = 0;
        this.stagingFileOutputStream = this.createStagingFileOutputStream();
        this.setStagingFileGroup();
    }

    public void write(byte[] record) throws IOException {
        Preconditions.checkNotNull((Object)record);
        byte[] toWrite = record;
        if (this.recordDelimiter.isPresent()) {
            toWrite = Arrays.copyOf(record, record.length + 1);
            toWrite[toWrite.length - 1] = (Byte)this.recordDelimiter.get();
        }
        if (this.prependSize) {
            long recordSize = toWrite.length;
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.putLong(recordSize);
            toWrite = ArrayUtils.addAll((byte[])buf.array(), (byte[])toWrite);
        }
        this.stagingFileOutputStream.write(toWrite);
        this.bytesWritten += toWrite.length;
        ++this.recordsWritten;
    }

    public long recordsWritten() {
        return this.recordsWritten;
    }

    @Override
    public long bytesWritten() throws IOException {
        return this.bytesWritten;
    }

    @Override
    public boolean isSpeculativeAttemptSafe() {
        return this.writerAttemptIdOptional.isPresent() && this.getClass() == SimpleDataWriter.class;
    }

    public void flush() throws IOException {
        this.stagingFileOutputStream.flush();
    }
}

