/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.io.IOException;
import java.util.Map;
import org.apache.gobblin.source.extractor.CheckpointableWatermark;
import org.apache.gobblin.stream.RecordEnvelope;
import org.apache.gobblin.writer.WatermarkAwareWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleWriter<D>
implements WatermarkAwareWriter<D> {
    private static final Logger log = LoggerFactory.getLogger(ConsoleWriter.class);
    private long _recordsWritten = 0L;

    public void write(D record) throws IOException {
        System.out.println(record);
        if (record != null) {
            log.info(record.toString());
        } else {
            log.info("null record");
        }
        ++this._recordsWritten;
    }

    public void commit() throws IOException {
        log.debug("Commit called.");
    }

    public void cleanup() throws IOException {
        log.debug("Cleanup called.");
    }

    public long recordsWritten() {
        return this._recordsWritten;
    }

    public long bytesWritten() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
        log.debug("Close called");
    }

    public boolean isWatermarkCapable() {
        return true;
    }

    public void writeEnvelope(RecordEnvelope<D> recordEnvelope) throws IOException {
        this.write(recordEnvelope.getRecord());
        recordEnvelope.ack();
    }

    public Map<String, CheckpointableWatermark> getCommittableWatermark() {
        throw new UnsupportedOperationException("This writer does not keep track of committed watermarks");
    }

    public Map<String, CheckpointableWatermark> getUnacknowledgedWatermark() {
        throw new UnsupportedOperationException("This writer does not keep track of uncommitted watermarks");
    }

    public void flush() throws IOException {
        System.out.flush();
    }
}

