/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.watermark;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.source.extractor.extract.QueryBasedExtractor;
import org.apache.gobblin.source.extractor.watermark.DateWatermark;
import org.apache.gobblin.source.extractor.watermark.HourWatermark;
import org.apache.gobblin.source.extractor.watermark.Predicate;
import org.apache.gobblin.source.extractor.watermark.SimpleWatermark;
import org.apache.gobblin.source.extractor.watermark.TimestampWatermark;
import org.apache.gobblin.source.extractor.watermark.Watermark;
import org.apache.gobblin.source.extractor.watermark.WatermarkType;

public class WatermarkPredicate {
    private static final String DEFAULT_WATERMARK_VALUE_FORMAT = "yyyyMMddHHmmss";
    private static final long DEFAULT_WATERMARK_VALUE = -1L;
    private String watermarkColumn;
    private WatermarkType watermarkType;
    private Watermark watermark;

    public WatermarkPredicate(WatermarkType watermarkType) {
        this(null, watermarkType);
    }

    public WatermarkPredicate(String watermarkColumn, WatermarkType watermarkType) {
        this.watermarkColumn = watermarkColumn;
        this.watermarkType = watermarkType;
        switch (watermarkType) {
            case TIMESTAMP: {
                this.watermark = new TimestampWatermark(watermarkColumn, DEFAULT_WATERMARK_VALUE_FORMAT);
                break;
            }
            case DATE: {
                this.watermark = new DateWatermark(watermarkColumn, DEFAULT_WATERMARK_VALUE_FORMAT);
                break;
            }
            case HOUR: {
                this.watermark = new HourWatermark(watermarkColumn, DEFAULT_WATERMARK_VALUE_FORMAT);
                break;
            }
            case SIMPLE: {
                this.watermark = new SimpleWatermark(watermarkColumn, DEFAULT_WATERMARK_VALUE_FORMAT);
                break;
            }
            default: {
                this.watermark = new SimpleWatermark(watermarkColumn, DEFAULT_WATERMARK_VALUE_FORMAT);
            }
        }
    }

    public Predicate getPredicate(QueryBasedExtractor<?, ?> extractor, long watermarkValue, String operator, Predicate.PredicateType type) {
        String condition = "";
        if (watermarkValue != -1L) {
            condition = this.watermark.getWatermarkCondition(extractor, watermarkValue, operator);
        }
        if (StringUtils.isBlank((CharSequence)this.watermarkColumn) || condition.equals("")) {
            return null;
        }
        return new Predicate(this.watermarkColumn, watermarkValue, condition, this.getWatermarkSourceFormat(extractor), type);
    }

    public String getWatermarkSourceFormat(QueryBasedExtractor<?, ?> extractor) {
        return extractor.getWatermarkSourceFormat(this.watermarkType);
    }

    public HashMap<Long, Long> getPartitions(long lowWatermarkValue, long highWatermarkValue, int partitionInterval, int maxIntervals) {
        return this.watermark.getIntervals(lowWatermarkValue, highWatermarkValue, partitionInterval, maxIntervals);
    }

    public int getDeltaNumForNextWatermark() {
        return this.watermark.getDeltaNumForNextWatermark();
    }
}

