/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.filebased;

import com.google.common.base.Throwables;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FileByteIterator
implements Iterator<Byte> {
    private BufferedInputStream bufferedInputStream;

    public FileByteIterator(InputStream inputStream) {
        this.bufferedInputStream = new BufferedInputStream(inputStream);
    }

    @Override
    public boolean hasNext() {
        try {
            return this.bufferedInputStream.available() > 0;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Byte next() {
        try {
            if (this.hasNext()) {
                return (byte)this.bufferedInputStream.read();
            }
            throw new NoSuchElementException("No more data left in the file");
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

