/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.qualitychecker.row;

import com.google.common.io.Closer;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class RowLevelErrFileWriter
implements Closeable {
    private final FileSystem fs;
    private final Closer closer = Closer.create();
    private BufferedWriter writer;

    public RowLevelErrFileWriter(FileSystem fs) {
        this.fs = fs;
    }

    public void open(Path errFilePath) throws IOException {
        this.fs.mkdirs(errFilePath.getParent());
        OutputStream os = (OutputStream)this.closer.register((Closeable)(this.fs.exists(errFilePath) ? this.fs.append(errFilePath) : this.fs.create(errFilePath)));
        this.writer = (BufferedWriter)this.closer.register((Closeable)new BufferedWriter(new OutputStreamWriter(os, ConfigurationKeys.DEFAULT_CHARSET_ENCODING)));
    }

    public void write(Object record) throws IOException {
        this.writer.write(record.toString());
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

