/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.publisher;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.commit.CommitSequence;
import org.apache.gobblin.commit.FsRenameCommitStep;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.publisher.BaseDataPublisher;
import org.apache.gobblin.util.ParallelRunner;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class CommitSequencePublisher
extends BaseDataPublisher {
    private static final Logger log = LoggerFactory.getLogger(CommitSequencePublisher.class);
    protected Optional<CommitSequence.Builder> commitSequenceBuilder = Optional.of((Object)new CommitSequence.Builder());

    public CommitSequencePublisher(State state) throws IOException {
        super(state);
    }

    public void publish(Collection<? extends WorkUnitState> states) throws IOException {
        super.publish(states);
        if (!states.isEmpty()) {
            String jobName = ((WorkUnitState)Iterables.get(states, (int)0)).getProp("job.name");
            String datasetUrn = ((WorkUnitState)Iterables.get(states, (int)0)).getProp("dataset.urn", "");
            ((CommitSequence.Builder)this.commitSequenceBuilder.get()).withJobName(jobName).withDatasetUrn(datasetUrn);
        } else {
            log.warn("No workunitstate to publish");
            this.commitSequenceBuilder = Optional.absent();
        }
    }

    @Override
    protected void movePath(ParallelRunner parallelRunner, State state, Path src, Path dst, int branchId) throws IOException {
        log.info(String.format("Creating CommitStep for moving %s to %s", src, dst));
        boolean overwrite = state.getPropAsBoolean("data.publisher.overwrite.enabled", false);
        Object builder = ((FsRenameCommitStep.Builder)((Object)((FsRenameCommitStep.Builder)((Object)((FsRenameCommitStep.Builder)((Object)((FsRenameCommitStep.Builder)((CommitSequence.Builder)this.commitSequenceBuilder.get()).beginStep(FsRenameCommitStep.Builder.class)).withProps(this.state).from(src))).withSrcFs((FileSystem)this.writerFileSystemByBranches.get(branchId)))).to(dst))).withDstFs((FileSystem)this.publisherFileSystemByBranches.get(branchId));
        if (overwrite) {
            ((FsRenameCommitStep.Builder)((Object)builder)).overwrite();
        }
        builder.endStep();
    }

    public Optional<CommitSequence.Builder> getCommitSequenceBuilder() {
        return this.commitSequenceBuilder;
    }
}

