/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.policies.schema;

import org.apache.gobblin.configuration.State;
import org.apache.gobblin.qualitychecker.task.TaskLevelPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCompatibilityPolicy
extends TaskLevelPolicy {
    private static final Logger log = LoggerFactory.getLogger(SchemaCompatibilityPolicy.class);
    private State state;
    private State previousState;

    public SchemaCompatibilityPolicy(State state, TaskLevelPolicy.Type type) {
        super(state, type);
        this.state = state;
        this.previousState = this.getPreviousTableState();
    }

    public TaskLevelPolicy.Result executePolicy() {
        if (this.previousState.getProp("extract.schema") == null) {
            log.info("Previous Task State does not contain a schema");
            return TaskLevelPolicy.Result.PASSED;
        }
        if (this.state.getProp("extract.schema").equals(this.previousState.getProp("extract.schema"))) {
            return TaskLevelPolicy.Result.PASSED;
        }
        return TaskLevelPolicy.Result.FAILED;
    }
}

