/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.objectstore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.converter.objectstore.ObjectStoreConverter;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.writer.objectstore.ObjectStoreDeleteOperation;
import org.apache.gobblin.writer.objectstore.ObjectStoreOperationBuilder;

@Alpha
public class ObjectStoreDeleteConverter
extends ObjectStoreConverter<Schema, GenericRecord, ObjectStoreDeleteOperation> {
    @VisibleForTesting
    public static final String OBJECT_ID_FIELD = "gobblin.converter.objectstore.delete.objectIdField";
    private String objectIdField;

    @Override
    public ObjectStoreDeleteConverter init(WorkUnitState workUnit) {
        Preconditions.checkArgument((boolean)workUnit.contains(OBJECT_ID_FIELD), (Object)String.format("%s is a required property. ", OBJECT_ID_FIELD));
        this.objectIdField = workUnit.getProp(OBJECT_ID_FIELD);
        return this;
    }

    public Iterable<ObjectStoreDeleteOperation> convertRecord(Class<?> outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        Optional fieldValue = AvroUtils.getFieldValue((GenericRecord)inputRecord, (String)this.objectIdField);
        if (fieldValue.isPresent()) {
            byte[] objectId = fieldValue.get() instanceof Utf8 ? ((Utf8)fieldValue.get()).getBytes() : (fieldValue.get() instanceof String ? ((String)fieldValue.get()).getBytes(Charsets.UTF_8) : (fieldValue.get() instanceof Long ? Longs.toByteArray((long)((Long)fieldValue.get())) : (fieldValue.get() instanceof Integer ? Ints.toByteArray((int)((Integer)fieldValue.get())) : (byte[])fieldValue.get())));
            return new SingleRecordIterable((Object)ObjectStoreOperationBuilder.deleteBuilder().withObjectId(objectId).build());
        }
        throw new DataConversionException(String.format("Object Id field %s not found in record %s", this.objectIdField, inputRecord));
    }
}

