/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.async;

import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.async.BufferedRecord;
import org.apache.gobblin.async.Callback;
import org.apache.gobblin.net.Request;

public class AsyncRequest<D, RQ>
implements Request<RQ> {
    private int recordCount = 0;
    protected long bytesWritten = 0L;
    private RQ rawRequest;
    private final List<Thunk> thunks = new ArrayList<Thunk>();

    public void markRecord(BufferedRecord<D> record, int bytesWritten) {
        if (record.getCallback() != null) {
            this.thunks.add(new Thunk(record.getCallback(), bytesWritten));
        }
        ++this.recordCount;
        this.bytesWritten += (long)bytesWritten;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public RQ getRawRequest() {
        return this.rawRequest;
    }

    public void setRawRequest(RQ rawRequest) {
        this.rawRequest = rawRequest;
    }

    public List<Thunk> getThunks() {
        return this.thunks;
    }

    public static final class Thunk {
        public final Callback callback;
        public final int sizeInBytes;

        Thunk(Callback callback, int sizeInBytes) {
            this.callback = callback;
            this.sizeInBytes = sizeInBytes;
        }
    }
}

