/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.async;

import com.google.common.util.concurrent.AbstractExecutionThreadService;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.gobblin.async.DispatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AsyncDataDispatcher<D>
extends AbstractExecutionThreadService {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncDataDispatcher.class);
    private final BlockingQueue<D> buffer;
    private final Lock lock;
    private final Condition isBufferEmpty;

    public AsyncDataDispatcher(int capacity) {
        this.buffer = new ArrayBlockingQueue<D>(capacity);
        this.lock = new ReentrantLock(true);
        this.isBufferEmpty = this.lock.newCondition();
        this.startAsync();
        this.awaitRunning();
    }

    protected abstract void dispatch(Queue<D> var1) throws DispatchException;

    protected void put(D record) {
        this.checkRunning("put");
        try {
            this.buffer.put(record);
            if (!this.isRunning()) {
                this.buffer.clear();
                RuntimeException e = new RuntimeException("Attempt to operate when writer is " + this.state().name());
                LOG.error("put", (Throwable)e);
                throw e;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Waiting to put a record interrupted", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void run() throws Exception {
        AsyncDataDispatcher.LOG.info("Start processing records");
        while (true) {
            if (this.buffer.isEmpty()) {
                this.notifyBufferEmptyOccurrence();
                if (!this.isRunning()) {
                    return;
                }
                try {
                    Thread.sleep(300L);
                    continue;
                }
                catch (InterruptedException e) {
                    AsyncDataDispatcher.LOG.warn("Dispatcher sleep interrupted", (Throwable)e);
                }
            }
            try {
                this.dispatch(this.buffer);
                continue;
            }
            catch (DispatchException e) {
                AsyncDataDispatcher.LOG.error("Dispatch incurs an exception", (Throwable)e);
                if (e.isFatal()) ** break;
                continue;
                this.stopAsync();
                this.buffer.clear();
                this.notifyBufferEmptyOccurrence();
                throw e;
            }
            break;
        }
    }

    public void terminate() {
        this.stopAsync().awaitTerminated();
    }

    protected void checkRunning(String forWhat) {
        if (!this.isRunning()) {
            RuntimeException e = new RuntimeException("Attempt to operate when writer is " + this.state().name());
            LOG.error(forWhat, (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void waitForBufferEmpty() {
        this.checkRunning("waitForBufferEmpty");
        try {
            this.lock.lock();
            while (!this.buffer.isEmpty()) {
                try {
                    this.isBufferEmpty.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Waiting for buffer flush interrupted", e);
                    return;
                }
            }
        }
        finally {
            this.lock.unlock();
            this.checkRunning("waitForBufferEmpty");
        }
    }

    private void notifyBufferEmptyOccurrence() {
        try {
            this.lock.lock();
            this.isBufferEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

