/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive.spec.predicate;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.gobblin.hive.HiveRegister;

public class TableNotExistPredicate
implements Predicate<HiveRegister> {
    protected final String dbName;
    protected final String tableName;

    public boolean apply(HiveRegister register) {
        try {
            return !register.existsTable(this.dbName, this.tableName);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @ConstructorProperties(value={"dbName", "tableName"})
    public TableNotExistPredicate(String dbName, String tableName) {
        this.dbName = dbName;
        this.tableName = tableName;
    }
}

