/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.avro.AvroSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;

@Alpha
public class HiveSerDeWrapper {
    private static final String SERDE_SERIALIZER_PREFIX = "serde.serializer.";
    private static final String SERDE_DESERIALIZER_PREFIX = "serde.deserializer.";
    public static final String SERDE_SERIALIZER_TYPE = "serde.serializer.type";
    public static final String SERDE_SERIALIZER_INPUT_FORMAT_TYPE = "serde.serializer.input.format.type";
    public static final String SERDE_SERIALIZER_OUTPUT_FORMAT_TYPE = "serde.serializer.output.format.type";
    public static final String SERDE_DESERIALIZER_TYPE = "serde.deserializer.type";
    public static final String SERDE_DESERIALIZER_INPUT_FORMAT_TYPE = "serde.deserializer.input.format.type";
    public static final String SERDE_DESERIALIZER_OUTPUT_FORMAT_TYPE = "serde.deserializer.output.format.type";
    private Optional<SerDe> serDe = Optional.absent();
    private final String serDeClassName;
    private final String inputFormatClassName;
    private final String outputFormatClassName;

    private HiveSerDeWrapper(BuiltInHiveSerDe hiveSerDe) {
        this(hiveSerDe.serDeClassName, hiveSerDe.inputFormatClassName, hiveSerDe.outputFormatClassName);
    }

    private HiveSerDeWrapper(String serDeClassName, String inputFormatClassName, String outputFormatClassName) {
        this.serDeClassName = serDeClassName;
        this.inputFormatClassName = inputFormatClassName;
        this.outputFormatClassName = outputFormatClassName;
    }

    public SerDe getSerDe() throws IOException {
        if (!this.serDe.isPresent()) {
            try {
                this.serDe = Optional.of(SerDe.class.cast(Class.forName(this.serDeClassName).newInstance()));
            }
            catch (Throwable t) {
                throw new IOException("Failed to instantiate SerDe " + this.serDeClassName, t);
            }
        }
        return (SerDe)this.serDe.get();
    }

    public String getInputFormatClassName() {
        return this.inputFormatClassName;
    }

    public String getOutputFormatClassName() {
        return this.outputFormatClassName;
    }

    public static HiveSerDeWrapper get(String serDeType) {
        return HiveSerDeWrapper.get(serDeType, (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent());
    }

    public static HiveSerDeWrapper get(String serDeType, Optional<String> inputFormatClassName, Optional<String> outputFormatClassName) {
        Optional hiveSerDe = Enums.getIfPresent(BuiltInHiveSerDe.class, (String)serDeType.toUpperCase());
        if (hiveSerDe.isPresent()) {
            return new HiveSerDeWrapper((BuiltInHiveSerDe)((Object)hiveSerDe.get()));
        }
        Preconditions.checkArgument((boolean)inputFormatClassName.isPresent(), (Object)("Missing input format class name for SerDe " + serDeType));
        Preconditions.checkArgument((boolean)outputFormatClassName.isPresent(), (Object)("Missing output format class name for SerDe " + serDeType));
        return new HiveSerDeWrapper(serDeType, (String)inputFormatClassName.get(), (String)outputFormatClassName.get());
    }

    public static HiveSerDeWrapper getSerializer(State state) {
        Preconditions.checkArgument((boolean)state.contains(SERDE_SERIALIZER_TYPE), (Object)"Missing required property serde.serializer.type");
        return HiveSerDeWrapper.get(state.getProp(SERDE_SERIALIZER_TYPE), (Optional<String>)Optional.fromNullable((Object)state.getProp(SERDE_SERIALIZER_INPUT_FORMAT_TYPE)), (Optional<String>)Optional.fromNullable((Object)state.getProp(SERDE_SERIALIZER_OUTPUT_FORMAT_TYPE)));
    }

    public static HiveSerDeWrapper getDeserializer(State state) {
        Preconditions.checkArgument((boolean)state.contains(SERDE_DESERIALIZER_TYPE), (Object)"Missing required property serde.deserializer.type");
        return HiveSerDeWrapper.get(state.getProp(SERDE_DESERIALIZER_TYPE), (Optional<String>)Optional.fromNullable((Object)state.getProp(SERDE_DESERIALIZER_INPUT_FORMAT_TYPE)), (Optional<String>)Optional.fromNullable((Object)state.getProp(SERDE_DESERIALIZER_OUTPUT_FORMAT_TYPE)));
    }

    public static enum BuiltInHiveSerDe {
        AVRO(AvroSerDe.class.getName(), AvroContainerInputFormat.class.getName(), AvroContainerOutputFormat.class.getName()),
        ORC(OrcSerde.class.getName(), OrcInputFormat.class.getName(), OrcOutputFormat.class.getName()),
        PARQUET(ParquetHiveSerDe.class.getName(), MapredParquetInputFormat.class.getName(), MapredParquetOutputFormat.class.getName()),
        TEXTFILE(LazySimpleSerDe.class.getName(), TextInputFormat.class.getName(), HiveIgnoreKeyTextOutputFormat.class.getName());

        private final String serDeClassName;
        private final String inputFormatClassName;
        private final String outputFormatClassName;

        private BuiltInHiveSerDe(String serDeClassName, String inputFormatClassName, String outputFormatClassName) {
            this.serDeClassName = serDeClassName;
            this.inputFormatClassName = inputFormatClassName;
            this.outputFormatClassName = outputFormatClassName;
        }

        public String toString() {
            return this.serDeClassName;
        }
    }
}

