/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.rest;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.linkedin.r2.filter.FilterChain;
import com.linkedin.r2.filter.FilterChains;
import com.linkedin.r2.filter.compression.EncodingType;
import com.linkedin.r2.filter.compression.ServerCompressionFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.transport.common.RestRequestHandler;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import com.linkedin.r2.transport.http.server.HttpNettyServerFactory;
import com.linkedin.r2.transport.http.server.HttpServer;
import com.linkedin.restli.docgen.DefaultDocumentationRequestHandler;
import com.linkedin.restli.server.DelegatingTransportDispatcher;
import com.linkedin.restli.server.RestLiConfig;
import com.linkedin.restli.server.RestLiDocumentationRequestHandler;
import com.linkedin.restli.server.RestLiServer;
import com.linkedin.restli.server.mock.InjectMockResourceFactory;
import com.linkedin.restli.server.mock.SimpleBeanProvider;
import com.linkedin.restli.server.resources.BeanProvider;
import com.linkedin.restli.server.resources.ResourceFactory;
import java.net.URI;
import java.util.Properties;
import org.apache.gobblin.metastore.JobHistoryStore;
import org.apache.gobblin.metastore.MetaStoreModule;
import org.apache.gobblin.rest.JobExecutionInfoResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExecutionInfoServer
extends AbstractIdleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobExecutionInfoServer.class);
    private final URI serverUri;
    private final URI serverAdvertisedUri;
    private final int port;
    private final Properties properties;
    private volatile Optional<HttpServer> httpServer;

    public JobExecutionInfoServer(Properties properties) {
        this.properties = properties;
        this.port = JobExecutionInfoServer.getPort(properties);
        this.serverUri = JobExecutionInfoServer.getServiceUri(JobExecutionInfoServer.getHost(properties), this.port);
        this.serverAdvertisedUri = JobExecutionInfoServer.getAdvertisedUri(properties);
    }

    protected void startUp() throws Exception {
        RestLiConfig config = new RestLiConfig();
        config.addResourcePackageNames(new String[]{JobExecutionInfoResource.class.getPackage().getName()});
        config.setServerNodeUri(this.serverUri);
        config.setDocumentationRequestHandler((RestLiDocumentationRequestHandler)new DefaultDocumentationRequestHandler());
        Injector injector = Guice.createInjector((Module[])new Module[]{new MetaStoreModule(this.properties)});
        JobHistoryStore jobHistoryStore = (JobHistoryStore)injector.getInstance(JobHistoryStore.class);
        SimpleBeanProvider beanProvider = new SimpleBeanProvider();
        beanProvider.add("jobHistoryStore", (Object)jobHistoryStore);
        InjectMockResourceFactory factory = new InjectMockResourceFactory((BeanProvider)beanProvider);
        DelegatingTransportDispatcher dispatcher = new DelegatingTransportDispatcher((RestRequestHandler)new RestLiServer(config, (ResourceFactory)factory));
        String acceptedFilters = EncodingType.SNAPPY.getHttpName() + "," + EncodingType.GZIP.getHttpName();
        FilterChain filterChain = FilterChains.createRestChain((RestFilter[])new RestFilter[]{new ServerCompressionFilter(acceptedFilters)});
        this.httpServer = Optional.of((Object)new HttpNettyServerFactory(filterChain).createServer(this.port, (TransportDispatcher)dispatcher));
        LOGGER.info("Starting the job execution information server");
        ((HttpServer)this.httpServer.get()).start();
    }

    protected void shutDown() throws Exception {
        if (this.httpServer.isPresent()) {
            LOGGER.info("Stopping the job execution information server");
            ((HttpServer)this.httpServer.get()).stop();
        }
    }

    public URI getAdvertisedServerUri() {
        return this.serverAdvertisedUri;
    }

    private static URI getServiceUri(String host, int port) {
        return URI.create(String.format("http://%s:%d", host, port));
    }

    private static int getPort(Properties properties) {
        return Integer.parseInt(properties.getProperty("rest.server.port", "8080"));
    }

    private static String getHost(Properties properties) {
        return properties.getProperty("rest.server.host", "localhost");
    }

    private static URI getAdvertisedUri(Properties properties) {
        return URI.create(properties.getProperty("rest.server.advertised.uri", JobExecutionInfoServer.getServiceUri(JobExecutionInfoServer.getHost(properties), JobExecutionInfoServer.getPort(properties)).toString()));
    }
}

