/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.influxdb;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.MultiPartEvent;
import org.apache.gobblin.metrics.influxdb.InfluxDBConnectionType;
import org.apache.gobblin.metrics.influxdb.InfluxDBPusher;
import org.apache.gobblin.metrics.reporter.EventReporter;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBEventReporter
extends EventReporter {
    private final InfluxDBPusher influxDBPusher;
    private static final double EMTPY_VALUE = 0.0;
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluxDBEventReporter.class);

    public InfluxDBEventReporter(Builder<?> builder) throws IOException {
        super(builder);
        this.influxDBPusher = builder.influxDBPusher.isPresent() ? (InfluxDBPusher)builder.influxDBPusher.get() : new InfluxDBPusher.Builder(builder.url, builder.username, builder.password, builder.database, builder.connectionType).build();
    }

    public void reportEventQueue(Queue<GobblinTrackingEvent> queue) {
        try {
            GobblinTrackingEvent nextEvent;
            while (null != (nextEvent = queue.poll())) {
                this.pushEvent(nextEvent);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error sending event to InfluxDB", (Throwable)e);
        }
    }

    private void pushEvent(GobblinTrackingEvent event) throws IOException {
        Map metadata = event.getMetadata();
        String name = this.getMetricName(metadata, event.getName());
        long timestamp = event.getTimestamp();
        MultiPartEvent multiPartEvent = MultiPartEvent.getEvent((String)((String)metadata.get("eventType")));
        if (multiPartEvent == null) {
            this.influxDBPusher.push(this.buildEventAsPoint(name, 0.0, timestamp));
        } else {
            ArrayList points = Lists.newArrayList();
            for (String field : multiPartEvent.getMetadataFields()) {
                Point point = this.buildEventAsPoint(JOINER.join((Object)name, (Object)field, new Object[0]), this.convertValue(field, (String)metadata.get(field)), timestamp);
                points.add(point);
            }
            this.influxDBPusher.push(points);
        }
    }

    private Object convertValue(String field, String value) {
        if (value == null) {
            return 0.0;
        }
        if ("durationMillis".equals(field)) {
            return this.convertDuration(TimeUnit.MILLISECONDS.toNanos(Long.parseLong(value)));
        }
        Double doubleValue = Doubles.tryParse((String)value);
        return doubleValue == null ? value : doubleValue;
    }

    @Deprecated
    public static Builder<? extends Builder> forContext(MetricContext context) {
        return new BuilderImpl(context);
    }

    private Point buildEventAsPoint(String name, Object value, long timestamp) throws IOException {
        return Point.measurement((String)name).field("value", value).time(timestamp, TimeUnit.MILLISECONDS).build();
    }

    public static abstract class Builder<T extends EventReporter.Builder<T>>
    extends EventReporter.Builder<T> {
        protected String url;
        protected String username;
        protected String password;
        protected String database;
        protected InfluxDBConnectionType connectionType;
        protected Optional<InfluxDBPusher> influxDBPusher = Optional.absent();

        protected Builder(MetricContext context) {
            super(context);
            this.connectionType = InfluxDBConnectionType.TCP;
        }

        public T withInfluxDBPusher(InfluxDBPusher pusher) {
            this.influxDBPusher = Optional.of((Object)pusher);
            return (T)this.self();
        }

        public T withConnection(String url, String username, String password, String database) {
            this.url = url;
            this.username = username;
            this.password = password;
            this.database = database;
            return (T)this.self();
        }

        public T withConnectionType(InfluxDBConnectionType connectionType) {
            this.connectionType = connectionType;
            return (T)this.self();
        }

        public InfluxDBEventReporter build() throws IOException {
            return new InfluxDBEventReporter(this);
        }
    }

    public static class Factory {
        public static BuilderImpl forContext(MetricContext context) {
            return new BuilderImpl(context);
        }
    }

    public static class BuilderImpl
    extends Builder<BuilderImpl> {
        private BuilderImpl(MetricContext context) {
            super(context);
        }

        protected BuilderImpl self() {
            return this;
        }
    }
}

