/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.profile.internal.Profile;
import com.amazonaws.auth.profile.internal.ProfilesConfigFileLoader;
import com.amazonaws.auth.profile.internal.securitytoken.ProfileCredentialsService;
import com.amazonaws.auth.profile.internal.securitytoken.STSProfileCredentialsServiceLoader;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilesConfigFile {
    private static final Log LOG = LogFactory.getLog(ProfilesConfigFile.class);
    public static final String AWS_PROFILE_ENVIRONMENT_VARIABLE = "AWS_PROFILE";
    public static final String AWS_PROFILE_SYSTEM_PROPERTY = "aws.profile";
    @Deprecated
    private static final String LEGACY_CONFIG_FILE_ENVIRONMENT_VARIABLE = "AWS_CONFIG_FILE";
    private static final String CREDENTIAL_PROFILES_FILE_ENVIRONMENT_VARIABLE = "AWS_CREDENTIAL_PROFILES_FILE";
    @Deprecated
    private static final String LEGACY_CONFIG_PROFILES_FILENAME = "config";
    private static final String DEFAULT_CREDENTIAL_PROFILES_FILENAME = "credentials";
    public static final String DEFAULT_PROFILE_NAME = "default";
    private final File profileFile;
    private final ProfileCredentialsService profileCredentialsService;
    private volatile Map<String, Profile> profilesByName;
    private volatile long profileFileLastModified;

    public ProfilesConfigFile() throws AmazonClientException {
        this(ProfilesConfigFile.getCredentialProfilesFile());
    }

    public ProfilesConfigFile(String filePath) {
        this(new File(ProfilesConfigFile.validateFilePath(filePath)));
    }

    public ProfilesConfigFile(String filePath, ProfileCredentialsService credentialsService) throws AmazonClientException {
        this(new File(ProfilesConfigFile.validateFilePath(filePath)), credentialsService);
    }

    private static String validateFilePath(String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("Unable to load AWS profiles: specified file path is null.");
        }
        return filePath;
    }

    public ProfilesConfigFile(File file) throws AmazonClientException {
        this(file, (ProfileCredentialsService)STSProfileCredentialsServiceLoader.getInstance());
    }

    public ProfilesConfigFile(File file, ProfileCredentialsService credentialsService) throws AmazonClientException {
        this.profileFile = file;
        this.profileCredentialsService = credentialsService;
        this.profileFileLastModified = file.lastModified();
        this.profilesByName = ProfilesConfigFile.loadProfiles(this.profileFile, this.profileCredentialsService);
    }

    public AWSCredentials getCredentials(String profile) {
        Profile p = this.profilesByName.get(profile);
        if (p == null) {
            throw new IllegalArgumentException("No AWS profile named '" + profile + "'");
        }
        return p.getCredentials();
    }

    public void refresh() {
        if (this.profileFile.lastModified() > this.profileFileLastModified) {
            this.profileFileLastModified = this.profileFile.lastModified();
            this.profilesByName = ProfilesConfigFile.loadProfiles(this.profileFile, this.profileCredentialsService);
        }
    }

    public Map<String, Profile> getAllProfiles() {
        return new LinkedHashMap<String, Profile>(this.profilesByName);
    }

    private static File getCredentialProfilesFile() {
        boolean foundlegacyConfigProfiles;
        String legacyConfigFileOverride;
        String credentialProfilesFileOverride = System.getenv(CREDENTIAL_PROFILES_FILE_ENVIRONMENT_VARIABLE);
        if (credentialProfilesFileOverride == null && (legacyConfigFileOverride = System.getenv(LEGACY_CONFIG_FILE_ENVIRONMENT_VARIABLE)) != null) {
            LOG.warn((Object)String.format("Found the legacy environment variable [%s=%s]. Please use the latest environment variable to specify your credentials file override: [%s=%s]", LEGACY_CONFIG_FILE_ENVIRONMENT_VARIABLE, legacyConfigFileOverride, CREDENTIAL_PROFILES_FILE_ENVIRONMENT_VARIABLE, legacyConfigFileOverride));
        }
        if (credentialProfilesFileOverride != null) {
            LOG.debug((Object)("Loading AWS credential profiles from overridden file: " + credentialProfilesFileOverride));
            return new File(credentialProfilesFileOverride);
        }
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new AmazonClientException("Unable to load AWS profiles: 'user.home' System property is not set.");
        }
        File awsDirectory = new File(userHome, ".aws");
        File credentialProfiles = new File(awsDirectory, DEFAULT_CREDENTIAL_PROFILES_FILENAME);
        File legacyConfigProfiles = new File(awsDirectory, LEGACY_CONFIG_PROFILES_FILENAME);
        boolean foundCredentialProfiles = credentialProfiles.exists() && credentialProfiles.isFile();
        boolean bl = foundlegacyConfigProfiles = legacyConfigProfiles.exists() && legacyConfigProfiles.isFile();
        if (!foundCredentialProfiles && foundlegacyConfigProfiles) {
            LOG.warn((Object)("Found the legacy config profiles file at [" + legacyConfigProfiles.getAbsolutePath() + "]. Please move it to the latest default location [" + credentialProfiles + "]."));
            return legacyConfigProfiles;
        }
        return credentialProfiles;
    }

    private static Map<String, Profile> loadProfiles(File file, ProfileCredentialsService profileCredentialsService) {
        return new LinkedHashMap<String, Profile>(ProfilesConfigFileLoader.loadProfiles(file, profileCredentialsService));
    }
}

