/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataComplex;
import java.util.HashMap;

class DataObjectToObjectCache<V>
implements Cloneable {
    private HashMap<DataObjectKey, V> _cache;

    DataObjectToObjectCache() {
        this._cache = new HashMap();
    }

    DataObjectToObjectCache(int initialCapacity) {
        this._cache = new HashMap(initialCapacity);
    }

    public DataObjectToObjectCache<V> clone() throws CloneNotSupportedException {
        DataObjectToObjectCache cloned = (DataObjectToObjectCache)super.clone();
        cloned._cache = (HashMap)this._cache.clone();
        return cloned;
    }

    void put(Object dataObject, V value) {
        this._cache.put(new DataObjectKey(dataObject), value);
    }

    V get(Object dataObject) {
        return this._cache.get(new DataObjectKey(dataObject));
    }

    private class DataObjectKey {
        private Object _dataObject;
        private int _hashCode;

        DataObjectKey(Object dataObject) {
            this._hashCode = dataObject instanceof DataComplex ? ((DataComplex)dataObject).dataComplexHashCode() : dataObject.hashCode();
            this._dataObject = dataObject;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object other) {
            return this._dataObject == ((DataObjectKey)other)._dataObject;
        }
    }
}

