/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMapTemplate<V>
extends AbstractMap<String, V>
implements DataTemplate<DataMap> {
    protected DataMap _map;
    protected final MapDataSchema _schema;
    protected final Class<V> _valueClass;
    protected final Class<?> _dataClass;

    protected AbstractMapTemplate(DataMap map, MapDataSchema schema, Class<V> valueClass, Class<?> dataClass) {
        this._map = map;
        this._schema = schema;
        this._valueClass = valueClass;
        this._dataClass = dataClass;
    }

    @Override
    public MapDataSchema schema() {
        return this._schema;
    }

    @Override
    public DataMap data() {
        return this._map;
    }

    @Override
    public abstract boolean containsValue(Object var1);

    @Override
    public abstract Set<Map.Entry<String, V>> entrySet();

    @Override
    public abstract V get(Object var1);

    @Override
    public abstract V put(String var1, V var2);

    @Override
    public abstract V remove(Object var1);

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this._map.keySet();
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof AbstractMapTemplate) {
            return ((AbstractMapTemplate)object).data().equals(this._map);
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return this._map.hashCode();
    }

    @Override
    public String toString() {
        return this._map.toString();
    }

    @Override
    public AbstractMapTemplate<V> clone() throws CloneNotSupportedException {
        AbstractMapTemplate clone = (AbstractMapTemplate)super.clone();
        clone._map = clone._map.clone();
        return clone;
    }

    @Override
    public AbstractMapTemplate<V> copy() throws CloneNotSupportedException {
        AbstractMapTemplate copy = (AbstractMapTemplate)super.clone();
        copy._map = copy._map.copy();
        return copy;
    }

    protected Class<V> valueClass() {
        return this._valueClass;
    }

    protected static DataMap newDataMapOfSize(int srcMapSize) {
        return new DataMap((int)((float)srcMapSize / 0.75f) + 1, 0.75f);
    }

    protected static abstract class WrappingMapEntry<V>
    implements Map.Entry<String, V> {
        protected final Map.Entry<String, Object> _entry;
        protected V _value = null;

        public WrappingMapEntry(Map.Entry<String, Object> entry) {
            this._entry = entry;
        }

        @Override
        public String getKey() {
            return this._entry.getKey();
        }

        @Override
        public abstract V getValue() throws TemplateOutputCastException;

        @Override
        public abstract V setValue(V var1);

        @Override
        public boolean equals(Object o) {
            if (o == null || !(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            return this.getKey().equals(other.getKey()) && this.getValue().equals(other.getValue());
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getKey());
            builder.append('=');
            builder.append(this.getValue());
            return builder.toString();
        }
    }

    protected abstract class AbstractEntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        protected AbstractEntrySet() {
        }

        @Override
        public abstract boolean add(Map.Entry<String, V> var1);

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract Iterator<Map.Entry<String, V>> iterator();

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public abstract boolean removeAll(Collection<?> var1);

        @Override
        public abstract boolean retainAll(Collection<?> var1);

        @Override
        public void clear() {
            AbstractMapTemplate.this._map.entrySet().clear();
        }

        @Override
        public boolean isEmpty() {
            return AbstractMapTemplate.this._map.isEmpty();
        }

        @Override
        public int size() {
            return AbstractMapTemplate.this._map.size();
        }

        @Override
        public boolean equals(Object object) {
            if (object != null && object instanceof AbstractEntrySet) {
                AbstractEntrySet set = (AbstractEntrySet)object;
                return AbstractMapTemplate.this._map.equals(set.dataMap());
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            return AbstractMapTemplate.this._map.entrySet().hashCode();
        }

        @Override
        public String toString() {
            return AbstractMapTemplate.this._map.entrySet().toString();
        }

        private DataMap dataMap() {
            return AbstractMapTemplate.this._map;
        }
    }
}

