/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.compatibility;

import com.linkedin.data.message.Message;
import java.util.Formatter;

public class CompatibilityMessage
extends Message {
    private final Impact _impact;

    public CompatibilityMessage(Object[] path, Impact impact, String format, Object ... args) {
        super(path, impact.isError(), format, args);
        this._impact = impact;
    }

    protected CompatibilityMessage(CompatibilityMessage message, boolean error) {
        super(message.getPath(), error, message.getFormat(), message.getArgs());
        this._impact = message.getImpact();
    }

    public Impact getImpact() {
        return this._impact;
    }

    @Override
    public CompatibilityMessage asErrorMessage() {
        return this.isError() ? this : new CompatibilityMessage(this, true);
    }

    @Override
    public CompatibilityMessage asInfoMessage() {
        return this.isError() ? new CompatibilityMessage(this, false) : this;
    }

    @Override
    public Formatter format(Formatter formatter, String fieldSeparator) {
        this.formatError(formatter);
        this.formatSeparator(formatter, fieldSeparator);
        this.formatCompatibilityType(formatter);
        this.formatSeparator(formatter, fieldSeparator);
        this.formatPath(formatter);
        this.formatSeparator(formatter, fieldSeparator);
        this.formatArgs(formatter);
        return formatter;
    }

    protected void formatCompatibilityType(Formatter formatter) {
        formatter.format(this._impact.toString(), new Object[0]);
    }

    public static enum Impact {
        BREAKS_NEW_READER(true),
        BREAKS_OLD_READER(true),
        BREAKS_NEW_AND_OLD_READERS(true),
        NEW_READER_IGNORES_DATA(false),
        OLD_READER_IGNORES_DATA(false),
        VALUES_MAY_BE_TRUNCATED_OR_OVERFLOW(false);

        private final boolean _error;

        private Impact(boolean error) {
            this._error = error;
        }

        public boolean isError() {
            return this._error;
        }
    }
}

