/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.it;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.it.DataIterator;
import java.util.ArrayList;

public class Remover {
    public static Object remove(Object root, DataIterator it) {
        DataElement element;
        ArrayList<ToRemove> removeList = new ArrayList<ToRemove>();
        while ((element = it.next()) != null) {
            ToRemove toRemove = new ToRemove(element);
            removeList.add(toRemove);
        }
        for (int i = removeList.size() - 1; i >= 0; --i) {
            ToRemove toRemove = (ToRemove)removeList.get(i);
            if (toRemove.isRoot()) {
                root = null;
                continue;
            }
            toRemove.remove();
        }
        return root;
    }

    private static class ToRemove {
        private Object _parent;
        private Object _name;

        private ToRemove(DataElement element) {
            DataElement parentElement = element.getParent();
            this._parent = parentElement == null ? null : parentElement.getValue();
            this._name = element.getName();
        }

        private boolean isRoot() {
            return this._parent == null;
        }

        private void remove() {
            Class<?> nameClass = this._name.getClass();
            Class<?> parentClass = this._parent.getClass();
            if (nameClass == String.class) {
                assert (parentClass == DataMap.class);
                DataMap map = (DataMap)this._parent;
                map.remove(this._name);
            } else if (nameClass == Integer.class) {
                int index = (Integer)this._name;
                assert (parentClass == DataList.class);
                DataList list = (DataList)this._parent;
                list.remove(index);
            } else {
                throw new IllegalStateException("DataElement's name is not a String or Integer");
            }
        }
    }
}

