/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.it;

import com.linkedin.data.element.DataElement;
import com.linkedin.data.it.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OrPredicate
implements Predicate {
    Predicate[] _predicates;

    public OrPredicate(Predicate ... predicates) {
        this._predicates = predicates;
    }

    public OrPredicate(Collection<? extends Predicate> predicates) {
        this._predicates = predicates.toArray(new Predicate[0]);
    }

    @Override
    public boolean evaluate(DataElement element) {
        for (Predicate predicate : this._predicates) {
            if (!predicate.evaluate(element)) continue;
            return true;
        }
        return false;
    }

    public List<Predicate> getChildPredicates() {
        return Collections.unmodifiableList(Arrays.asList(this._predicates));
    }
}

