/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.DataDecodingException;
import com.linkedin.data.codec.DataEncodingException;
import com.linkedin.data.codec.DataLocation;
import com.linkedin.data.codec.TextDataCodec;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.util.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class JacksonDataCodec
implements TextDataCodec {
    protected boolean _allowComments;
    protected PrettyPrinter _prettyPrinter;
    protected JsonFactory _jsonFactory;
    protected int _defaultBufferSize = 4096;
    protected JsonEncoding _jsonEncoding = JsonEncoding.UTF8;

    public JacksonDataCodec() {
        this(new JsonFactory());
    }

    public JacksonDataCodec(JsonFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
        this._jsonFactory.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        this.setAllowComments(true);
    }

    public void setAllowComments(boolean allowComments) {
        this._jsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, allowComments);
        this._allowComments = allowComments;
    }

    public PrettyPrinter getPrettyPrinter() {
        return this._prettyPrinter;
    }

    public void setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._prettyPrinter = prettyPrinter;
    }

    @Override
    public String getStringEncoding() {
        return this._jsonEncoding.getJavaName();
    }

    @Override
    public byte[] mapToBytes(DataMap map) throws IOException {
        return this.objectToBytes(map);
    }

    @Override
    public String mapToString(DataMap map) throws IOException {
        return this.objectToString(map);
    }

    @Override
    public byte[] listToBytes(DataList list) throws IOException {
        return this.objectToBytes(list);
    }

    @Override
    public String listToString(DataList list) throws IOException {
        return this.objectToString(list);
    }

    protected byte[] objectToBytes(Object object) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(this._defaultBufferSize);
        this.writeObject(object, this.createJsonGenerator(out));
        return out.toByteArray();
    }

    protected String objectToString(Object object) throws IOException {
        StringWriter out = new StringWriter(this._defaultBufferSize);
        this.writeObject(object, this.createJsonGenerator(out));
        return out.toString();
    }

    @Override
    public DataMap bytesToMap(byte[] input) throws IOException {
        DataMap dataMap;
        Parser parser = new Parser();
        JsonParser jsonParser = null;
        try {
            jsonParser = this._jsonFactory.createParser(input);
            dataMap = parser.parse(jsonParser, DataMap.class);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JacksonDataCodec.closeJsonParserQuietly(jsonParser);
                throw throwable;
            }
        }
        JacksonDataCodec.closeJsonParserQuietly(jsonParser);
        return dataMap;
    }

    @Override
    public DataMap stringToMap(String input) throws IOException {
        DataMap dataMap;
        Parser parser = new Parser();
        JsonParser jsonParser = null;
        try {
            jsonParser = this._jsonFactory.createParser(input);
            dataMap = parser.parse(jsonParser, DataMap.class);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JacksonDataCodec.closeJsonParserQuietly(jsonParser);
                throw throwable;
            }
        }
        JacksonDataCodec.closeJsonParserQuietly(jsonParser);
        return dataMap;
    }

    @Override
    public DataList bytesToList(byte[] input) throws IOException {
        DataList dataList;
        Parser parser = new Parser();
        JsonParser jsonParser = null;
        try {
            jsonParser = this._jsonFactory.createParser(input);
            dataList = parser.parse(jsonParser, DataList.class);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JacksonDataCodec.closeJsonParserQuietly(jsonParser);
                throw throwable;
            }
        }
        JacksonDataCodec.closeJsonParserQuietly(jsonParser);
        return dataList;
    }

    @Override
    public DataList stringToList(String input) throws IOException {
        DataList dataList;
        Parser parser = new Parser();
        JsonParser jsonParser = null;
        try {
            jsonParser = this._jsonFactory.createParser(input);
            dataList = parser.parse(jsonParser, DataList.class);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JacksonDataCodec.closeJsonParserQuietly(jsonParser);
                throw throwable;
            }
        }
        JacksonDataCodec.closeJsonParserQuietly(jsonParser);
        return dataList;
    }

    @Override
    public void writeMap(DataMap map, OutputStream out) throws IOException {
        this.writeObject(map, this.createJsonGenerator(out));
    }

    @Override
    public void writeMap(DataMap map, Writer out) throws IOException {
        this.writeObject(map, this.createJsonGenerator(out));
    }

    @Override
    public void writeList(DataList list, OutputStream out) throws IOException {
        this.writeObject(list, this.createJsonGenerator(out));
    }

    @Override
    public void writeList(DataList list, Writer out) throws IOException {
        this.writeObject(list, this.createJsonGenerator(out));
    }

    protected JsonGenerator createJsonGenerator(OutputStream out) throws IOException {
        JsonGenerator generator = this._jsonFactory.createGenerator(out, this._jsonEncoding);
        if (this._prettyPrinter != null) {
            generator.setPrettyPrinter(this._prettyPrinter);
        }
        return generator;
    }

    protected JsonGenerator createJsonGenerator(Writer out) throws IOException {
        JsonGenerator generator = this._jsonFactory.createGenerator(out);
        if (this._prettyPrinter != null) {
            generator.setPrettyPrinter(this._prettyPrinter);
        }
        return generator;
    }

    protected void writeObject(Object object, JsonGenerator generator) throws IOException {
        try {
            JsonTraverseCallback callback = new JsonTraverseCallback(generator);
            Data.traverse(object, callback);
            generator.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                generator.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public DataMap readMap(InputStream in) throws IOException {
        DataMap dataMap;
        Parser parser = new Parser();
        JsonParser jsonParser = null;
        try {
            jsonParser = this._jsonFactory.createParser(in);
            dataMap = parser.parse(jsonParser, DataMap.class);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JacksonDataCodec.closeJsonParserQuietly(jsonParser);
                throw throwable;
            }
        }
        JacksonDataCodec.closeJsonParserQuietly(jsonParser);
        return dataMap;
    }

    @Override
    public DataMap readMap(Reader in) throws IOException {
        DataMap dataMap;
        Parser parser = new Parser();
        JsonParser jsonParser = null;
        try {
            jsonParser = this._jsonFactory.createParser(in);
            dataMap = parser.parse(jsonParser, DataMap.class);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JacksonDataCodec.closeJsonParserQuietly(jsonParser);
                throw throwable;
            }
        }
        JacksonDataCodec.closeJsonParserQuietly(jsonParser);
        return dataMap;
    }

    @Override
    public DataList readList(InputStream in) throws IOException {
        DataList dataList;
        Parser parser = new Parser();
        JsonParser jsonParser = null;
        try {
            jsonParser = this._jsonFactory.createParser(in);
            dataList = parser.parse(jsonParser, DataList.class);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JacksonDataCodec.closeJsonParserQuietly(jsonParser);
                throw throwable;
            }
        }
        JacksonDataCodec.closeJsonParserQuietly(jsonParser);
        return dataList;
    }

    @Override
    public DataList readList(Reader in) throws IOException {
        DataList dataList;
        Parser parser = new Parser();
        JsonParser jsonParser = null;
        try {
            jsonParser = this._jsonFactory.createParser(in);
            dataList = parser.parse(jsonParser, DataList.class);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JacksonDataCodec.closeJsonParserQuietly(jsonParser);
                throw throwable;
            }
        }
        JacksonDataCodec.closeJsonParserQuietly(jsonParser);
        return dataList;
    }

    public List<Object> parse(InputStream in, StringBuilder mesg, Map<Object, DataLocation> locationMap) throws IOException {
        List<Object> list;
        Parser parser = new Parser(true);
        JsonParser jsonParser = null;
        try {
            jsonParser = this._jsonFactory.createParser(in);
            list = parser.parse(jsonParser, mesg, locationMap);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JacksonDataCodec.closeJsonParserQuietly(jsonParser);
                throw throwable;
            }
        }
        JacksonDataCodec.closeJsonParserQuietly(jsonParser);
        return list;
    }

    public List<Object> parse(Reader in, StringBuilder mesg, Map<Object, DataLocation> locationMap) throws IOException {
        List<Object> list;
        Parser parser = new Parser(true);
        JsonParser jsonParser = null;
        try {
            jsonParser = this._jsonFactory.createParser(in);
            list = parser.parse(jsonParser, mesg, locationMap);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JacksonDataCodec.closeJsonParserQuietly(jsonParser);
                throw throwable;
            }
        }
        JacksonDataCodec.closeJsonParserQuietly(jsonParser);
        return list;
    }

    public void objectToJsonGenerator(Object object, JsonGenerator generator) throws IOException {
        JsonTraverseCallback callback = new JsonTraverseCallback(generator);
        Data.traverse(object, callback);
    }

    private static void closeJsonParserQuietly(JsonParser parser) {
        if (parser != null) {
            try {
                parser.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class Parser {
        private StringBuilder _errorBuilder = null;
        private JsonParser _parser = null;
        private boolean _debug = false;
        private Deque<Object> _nameStack = null;
        private Map<Object, DataLocation> _locationMap = null;

        Parser() {
            this(false);
        }

        Parser(boolean debug) {
            this._debug = debug;
        }

        private Map<DataLocation, Object> sortedLocationsMap() {
            if (this._locationMap == null) {
                return null;
            }
            TreeMap<DataLocation, Object> sortedMap = new TreeMap<DataLocation, Object>();
            for (Map.Entry<Object, DataLocation> e : this._locationMap.entrySet()) {
                sortedMap.put(e.getValue(), e.getKey());
            }
            return sortedMap;
        }

        List<Object> parse(JsonParser parser, StringBuilder mesg, Map<Object, DataLocation> locationMap) throws JsonParseException, IOException {
            JsonToken token;
            this._locationMap = locationMap;
            DataList list = new DataList();
            this._errorBuilder = mesg;
            if (this._debug) {
                this._nameStack = new ArrayDeque<Object>();
            }
            this._parser = parser;
            while ((token = this._parser.nextToken()) != null) {
                this.parse(list, null, null, token);
            }
            this._errorBuilder = null;
            return list;
        }

        <T extends DataComplex> T parse(JsonParser parser, Class<T> expectType) throws IOException {
            DataComplex result;
            this._errorBuilder = null;
            if (this._debug) {
                this._nameStack = new ArrayDeque<Object>();
            }
            this._parser = parser;
            JsonToken token = this._parser.nextToken();
            if (expectType == DataMap.class) {
                if (!JsonToken.START_OBJECT.equals((Object)token)) {
                    throw new DataDecodingException("JSON text for object must start with \"{\".");
                }
                DataMap map = new DataMap();
                this.parseDataMap(map);
                if (this._errorBuilder != null) {
                    map.addError(this._errorBuilder.toString());
                }
                result = (DataComplex)expectType.cast(map);
            } else if (expectType == DataList.class) {
                if (!JsonToken.START_ARRAY.equals((Object)token)) {
                    throw new DataDecodingException("JSON text for array must start with \"[\".");
                }
                DataList list = new DataList();
                this.parseDataList(list);
                if (this._errorBuilder != null) {
                    // empty if block
                }
                result = (DataComplex)expectType.cast(list);
            } else {
                throw new DataDecodingException("Expected type must be either DataMap or DataList.");
            }
            return (T)result;
        }

        private DataLocation currentDataLocation() {
            return this._locationMap == null ? null : new Location(this._parser.getTokenLocation());
        }

        private void saveDataLocation(Object o, DataLocation location) {
            if (this._locationMap != null && o != null) {
                assert (location != null);
                this._locationMap.put(o, location);
            }
        }

        private Object parse(DataList parentList, DataMap parentMap, String name, JsonToken token) throws IOException {
            Object value;
            if (token == null) {
                throw new DataDecodingException("Missing JSON token");
            }
            DataLocation location = this.currentDataLocation();
            switch (token) {
                case START_OBJECT: {
                    DataMap childMap = new DataMap();
                    value = childMap;
                    this.updateParent(parentList, parentMap, name, childMap);
                    this.parseDataMap(childMap);
                    break;
                }
                case START_ARRAY: {
                    DataList childList = new DataList();
                    value = childList;
                    this.updateParent(parentList, parentMap, name, childList);
                    this.parseDataList(childList);
                    break;
                }
                default: {
                    value = this.parsePrimitive(token);
                    if (value == null) break;
                    this.updateParent(parentList, parentMap, name, value);
                }
            }
            this.saveDataLocation(value, location);
            return value;
        }

        private void updateParent(DataList parentList, DataMap parentMap, String name, Object value) {
            if (parentMap != null) {
                Object replaced = CheckedUtil.putWithoutChecking(parentMap, name, value);
                if (replaced != null) {
                    if (this._errorBuilder == null) {
                        this._errorBuilder = new StringBuilder();
                    }
                    this._errorBuilder.append(new Location(this._parser.getTokenLocation())).append(": \"").append(name).append("\" defined more than once.\n");
                }
            } else {
                CheckedUtil.addWithoutChecking(parentList, value);
            }
        }

        private Object parsePrimitive(JsonToken token) throws IOException {
            Object object;
            block0 : switch (token) {
                case VALUE_STRING: {
                    object = this._parser.getText();
                    break;
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    JsonParser.NumberType numberType = this._parser.getNumberType();
                    switch (numberType) {
                        case INT: {
                            object = this._parser.getIntValue();
                            break block0;
                        }
                        case LONG: {
                            object = this._parser.getLongValue();
                            break block0;
                        }
                        case FLOAT: {
                            object = Float.valueOf(this._parser.getFloatValue());
                            break block0;
                        }
                        case DOUBLE: {
                            object = this._parser.getDoubleValue();
                            break block0;
                        }
                        case BIG_INTEGER: {
                            this.error(token, numberType);
                            object = null;
                            break block0;
                        }
                    }
                    this.error(token, numberType);
                    object = null;
                    break;
                }
                case VALUE_TRUE: {
                    object = Boolean.TRUE;
                    break;
                }
                case VALUE_FALSE: {
                    object = Boolean.FALSE;
                    break;
                }
                case VALUE_NULL: {
                    object = Data.NULL;
                    break;
                }
                default: {
                    this.error(token, null);
                    object = null;
                }
            }
            return object;
        }

        private void parseDataMap(DataMap map) throws IOException {
            while (this._parser.nextToken() != JsonToken.END_OBJECT) {
                String key = this._parser.getCurrentName();
                if (this._debug) {
                    this._nameStack.addLast(key);
                }
                JsonToken token = this._parser.nextToken();
                this.parse(null, map, key, token);
                if (!this._debug) continue;
                this._nameStack.removeLast();
            }
        }

        private void parseDataList(DataList list) throws IOException {
            JsonToken token;
            int index = 0;
            while ((token = this._parser.nextToken()) != JsonToken.END_ARRAY) {
                if (this._debug) {
                    this._nameStack.addLast(index);
                    ++index;
                }
                this.parse(list, null, null, token);
                if (!this._debug) continue;
                this._nameStack.removeLast();
            }
        }

        private void error(JsonToken token, JsonParser.NumberType type) throws IOException {
            if (this._errorBuilder == null) {
                this._errorBuilder = new StringBuilder();
            }
            this._errorBuilder.append(this._parser.getTokenLocation()).append(": ");
            if (this._debug) {
                this._errorBuilder.append("name: ");
                Data.appendNames(this._errorBuilder, this._nameStack);
                this._errorBuilder.append(", ");
            }
            this._errorBuilder.append("value: ").append(this._parser.getText()).append(", token: ").append(token);
            if (type != null) {
                this._errorBuilder.append(", number type: ").append(type);
            }
            this._errorBuilder.append(" not parsed.\n");
        }
    }

    private static class Location
    implements DataLocation {
        private final JsonLocation _location;

        private Location(JsonLocation location) {
            this._location = location;
        }

        public int getColumn() {
            return this._location.getColumnNr();
        }

        public int getLine() {
            return this._location.getLineNr();
        }

        @Override
        public int compareTo(DataLocation other) {
            return (int)(this._location.getCharOffset() - ((Location)other)._location.getCharOffset());
        }

        public String toString() {
            return this.getLine() + "," + this.getColumn();
        }
    }

    protected static class JsonTraverseCallback
    implements Data.TraverseCallback {
        private final JsonGenerator _jsonGenerator;

        protected JsonTraverseCallback(JsonGenerator jsonGenerator) {
            this._jsonGenerator = jsonGenerator;
        }

        @Override
        public Iterable<Map.Entry<String, Object>> orderMap(DataMap map) {
            return map.entrySet();
        }

        @Override
        public void nullValue() throws IOException {
            this._jsonGenerator.writeNull();
        }

        @Override
        public void booleanValue(boolean value) throws IOException {
            this._jsonGenerator.writeBoolean(value);
        }

        @Override
        public void integerValue(int value) throws IOException {
            this._jsonGenerator.writeNumber(value);
        }

        @Override
        public void longValue(long value) throws IOException {
            this._jsonGenerator.writeNumber(value);
        }

        @Override
        public void floatValue(float value) throws IOException {
            this._jsonGenerator.writeNumber(value);
        }

        @Override
        public void doubleValue(double value) throws IOException {
            this._jsonGenerator.writeNumber(value);
        }

        @Override
        public void stringValue(String value) throws IOException {
            this._jsonGenerator.writeString(value);
        }

        @Override
        public void byteStringValue(ByteString value) throws IOException {
            this._jsonGenerator.writeString(value.asAvroString());
        }

        @Override
        public void illegalValue(Object value) throws DataEncodingException {
            throw new DataEncodingException("Illegal value encountered: " + value);
        }

        @Override
        public void emptyMap() throws IOException {
            this._jsonGenerator.writeStartObject();
            this._jsonGenerator.writeEndObject();
        }

        @Override
        public void startMap(DataMap map) throws IOException {
            this._jsonGenerator.writeStartObject();
        }

        @Override
        public void key(String key) throws IOException {
            this._jsonGenerator.writeFieldName(key);
        }

        @Override
        public void endMap() throws IOException {
            this._jsonGenerator.writeEndObject();
        }

        @Override
        public void emptyList() throws IOException {
            this._jsonGenerator.writeStartArray();
            this._jsonGenerator.writeEndArray();
        }

        @Override
        public void startList(DataList list) throws IOException {
            this._jsonGenerator.writeStartArray();
        }

        @Override
        public void index(int index) {
        }

        @Override
        public void endList() throws IOException {
            this._jsonGenerator.writeEndArray();
        }
    }
}

