/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import com.typesafe.config.Config;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TimeZone;
import org.apache.gobblin.metrics.reporter.ConfiguredScheduledReporter;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputStreamReporter
extends ConfiguredScheduledReporter {
    private static final String TAGS_SECTION = "-- Tags";
    private static final String GAUGES_SECTION = "-- Gauges";
    private static final String COUNTERS_SECTION = "-- Counters";
    private static final String HISTOGRAMS_SECTION = "-- Histograms";
    private static final String METERS_SECTION = "-- Meters";
    private static final String TIMERS_SECTION = "-- Times";
    private static final Logger LOGGER = LoggerFactory.getLogger(OutputStreamReporter.class);
    private static final int CONSOLE_WIDTH = 80;
    private final PrintStream output;
    private final Locale locale;
    private final Clock clock;
    private final DateFormat dateFormat;
    private final ByteArrayOutputStream outputBuffer;
    private final PrintStream outputBufferPrintStream;
    private final Closer closer = Closer.create();

    private OutputStreamReporter(Builder<?> builder, Config config) {
        super(builder, config);
        this.output = (PrintStream)this.closer.register((Closeable)builder.output);
        this.locale = builder.locale;
        this.clock = builder.clock;
        this.dateFormat = DateFormat.getDateTimeInstance(3, 2, this.locale);
        this.dateFormat.setTimeZone(builder.timeZone);
        this.outputBuffer = new ByteArrayOutputStream();
        try {
            this.outputBufferPrintStream = (PrintStream)this.closer.register((Closeable)new PrintStream((OutputStream)this.outputBuffer, false, Charsets.UTF_8.toString()));
        }
        catch (UnsupportedEncodingException re) {
            throw new RuntimeException("This should never happen.", re);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.closer.close();
        }
        catch (IOException exception) {
            LOGGER.warn("Failed to close output streams.");
        }
        finally {
            super.close();
        }
    }

    @Override
    protected synchronized void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers, Map<String, Object> tags) {
        this.outputBuffer.reset();
        String dateTime = this.dateFormat.format(new Date(this.clock.getTime()));
        this.printWithBanner(dateTime, '=');
        this.outputBufferPrintStream.println();
        HashMap allTags = Maps.newHashMap();
        allTags.putAll(tags);
        allTags.putAll(this.tags);
        if (!allTags.isEmpty()) {
            this.printWithBanner(TAGS_SECTION, '-');
            for (Map.Entry<Object, Object> entry : allTags.entrySet()) {
                this.outputBufferPrintStream.println(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
            this.outputBufferPrintStream.println();
        }
        if (!gauges.isEmpty()) {
            this.printWithBanner(GAUGES_SECTION, '-');
            for (Map.Entry<Object, Object> entry : gauges.entrySet()) {
                this.outputBufferPrintStream.println((String)entry.getKey());
                this.printGauge(entry);
            }
            this.outputBufferPrintStream.println();
        }
        if (!counters.isEmpty()) {
            this.printWithBanner(COUNTERS_SECTION, '-');
            for (Map.Entry<Object, Object> entry : counters.entrySet()) {
                this.outputBufferPrintStream.println((String)entry.getKey());
                this.printCounter(entry);
            }
            this.outputBufferPrintStream.println();
        }
        if (!histograms.isEmpty()) {
            this.printWithBanner(HISTOGRAMS_SECTION, '-');
            for (Map.Entry<Object, Object> entry : histograms.entrySet()) {
                this.outputBufferPrintStream.println((String)entry.getKey());
                this.printHistogram((Histogram)entry.getValue());
            }
            this.outputBufferPrintStream.println();
        }
        if (!meters.isEmpty()) {
            this.printWithBanner(METERS_SECTION, '-');
            for (Map.Entry<Object, Object> entry : meters.entrySet()) {
                this.outputBufferPrintStream.println((String)entry.getKey());
                this.printMeter((Meter)entry.getValue());
            }
            this.outputBufferPrintStream.println();
        }
        if (!timers.isEmpty()) {
            this.printWithBanner(TIMERS_SECTION, '-');
            for (Map.Entry<Object, Object> entry : timers.entrySet()) {
                this.outputBufferPrintStream.println((String)entry.getKey());
                this.printTimer((Timer)entry.getValue());
            }
            this.outputBufferPrintStream.println();
        }
        this.outputBufferPrintStream.println();
        this.outputBufferPrintStream.flush();
        try {
            this.outputBuffer.writeTo(this.output);
        }
        catch (IOException exception) {
            LOGGER.warn("Failed to write metric report to output stream.");
        }
    }

    private void printMeter(Meter meter) {
        this.outputBufferPrintStream.printf(this.locale, "             count = %d%n", meter.getCount());
        this.outputBufferPrintStream.printf(this.locale, "         mean rate = %2.2f events/%s%n", new Object[]{this.convertRate(meter.getMeanRate()), this.getRateUnit()});
        this.outputBufferPrintStream.printf(this.locale, "     1-minute rate = %2.2f events/%s%n", new Object[]{this.convertRate(meter.getOneMinuteRate()), this.getRateUnit()});
        this.outputBufferPrintStream.printf(this.locale, "     5-minute rate = %2.2f events/%s%n", new Object[]{this.convertRate(meter.getFiveMinuteRate()), this.getRateUnit()});
        this.outputBufferPrintStream.printf(this.locale, "    15-minute rate = %2.2f events/%s%n", new Object[]{this.convertRate(meter.getFifteenMinuteRate()), this.getRateUnit()});
    }

    private void printCounter(Map.Entry<String, Counter> entry) {
        this.outputBufferPrintStream.printf(this.locale, "             count = %d%n", entry.getValue().getCount());
    }

    private void printGauge(Map.Entry<String, Gauge> entry) {
        this.outputBufferPrintStream.printf(this.locale, "             value = %s%n", entry.getValue().getValue());
    }

    private void printHistogram(Histogram histogram) {
        this.outputBufferPrintStream.printf(this.locale, "             count = %d%n", histogram.getCount());
        Snapshot snapshot = histogram.getSnapshot();
        this.outputBufferPrintStream.printf(this.locale, "               min = %d%n", snapshot.getMin());
        this.outputBufferPrintStream.printf(this.locale, "               max = %d%n", snapshot.getMax());
        this.outputBufferPrintStream.printf(this.locale, "              mean = %2.2f%n", snapshot.getMean());
        this.outputBufferPrintStream.printf(this.locale, "            stddev = %2.2f%n", snapshot.getStdDev());
        this.outputBufferPrintStream.printf(this.locale, "            median = %2.2f%n", snapshot.getMedian());
        this.outputBufferPrintStream.printf(this.locale, "              75%% <= %2.2f%n", snapshot.get75thPercentile());
        this.outputBufferPrintStream.printf(this.locale, "              95%% <= %2.2f%n", snapshot.get95thPercentile());
        this.outputBufferPrintStream.printf(this.locale, "              98%% <= %2.2f%n", snapshot.get98thPercentile());
        this.outputBufferPrintStream.printf(this.locale, "              99%% <= %2.2f%n", snapshot.get99thPercentile());
        this.outputBufferPrintStream.printf(this.locale, "            99.9%% <= %2.2f%n", snapshot.get999thPercentile());
    }

    private void printTimer(Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        this.outputBufferPrintStream.printf(this.locale, "             count = %d%n", timer.getCount());
        this.outputBufferPrintStream.printf(this.locale, "         mean rate = %2.2f calls/%s%n", new Object[]{this.convertRate(timer.getMeanRate()), this.getRateUnit()});
        this.outputBufferPrintStream.printf(this.locale, "     1-minute rate = %2.2f calls/%s%n", new Object[]{this.convertRate(timer.getOneMinuteRate()), this.getRateUnit()});
        this.outputBufferPrintStream.printf(this.locale, "     5-minute rate = %2.2f calls/%s%n", new Object[]{this.convertRate(timer.getFiveMinuteRate()), this.getRateUnit()});
        this.outputBufferPrintStream.printf(this.locale, "    15-minute rate = %2.2f calls/%s%n", new Object[]{this.convertRate(timer.getFifteenMinuteRate()), this.getRateUnit()});
        this.outputBufferPrintStream.printf(this.locale, "               min = %2.2f %s%n", new Object[]{this.convertDuration(snapshot.getMin()), this.getDurationUnit()});
        this.outputBufferPrintStream.printf(this.locale, "               max = %2.2f %s%n", new Object[]{this.convertDuration(snapshot.getMax()), this.getDurationUnit()});
        this.outputBufferPrintStream.printf(this.locale, "              mean = %2.2f %s%n", new Object[]{this.convertDuration(snapshot.getMean()), this.getDurationUnit()});
        this.outputBufferPrintStream.printf(this.locale, "            stddev = %2.2f %s%n", new Object[]{this.convertDuration(snapshot.getStdDev()), this.getDurationUnit()});
        this.outputBufferPrintStream.printf(this.locale, "            median = %2.2f %s%n", new Object[]{this.convertDuration(snapshot.getMedian()), this.getDurationUnit()});
        this.outputBufferPrintStream.printf(this.locale, "              75%% <= %2.2f %s%n", new Object[]{this.convertDuration(snapshot.get75thPercentile()), this.getDurationUnit()});
        this.outputBufferPrintStream.printf(this.locale, "              95%% <= %2.2f %s%n", new Object[]{this.convertDuration(snapshot.get95thPercentile()), this.getDurationUnit()});
        this.outputBufferPrintStream.printf(this.locale, "              98%% <= %2.2f %s%n", new Object[]{this.convertDuration(snapshot.get98thPercentile()), this.getDurationUnit()});
        this.outputBufferPrintStream.printf(this.locale, "              99%% <= %2.2f %s%n", new Object[]{this.convertDuration(snapshot.get99thPercentile()), this.getDurationUnit()});
        this.outputBufferPrintStream.printf(this.locale, "            99.9%% <= %2.2f %s%n", new Object[]{this.convertDuration(snapshot.get999thPercentile()), this.getDurationUnit()});
    }

    private void printWithBanner(String s, char c) {
        this.outputBufferPrintStream.print(s);
        this.outputBufferPrintStream.print(' ');
        for (int i = 0; i < 80 - s.length() - 1; ++i) {
            this.outputBufferPrintStream.print(c);
        }
        this.outputBufferPrintStream.println();
    }

    public static abstract class Builder<T extends ConfiguredScheduledReporter.Builder<T>>
    extends ConfiguredScheduledReporter.Builder<T> {
        protected PrintStream output;
        protected Locale locale;
        protected Clock clock;
        protected TimeZone timeZone;

        protected Builder() {
            this.name = "OutputStreamReporter";
            this.output = System.out;
            this.locale = Locale.getDefault();
            this.clock = Clock.defaultClock();
            this.timeZone = TimeZone.getDefault();
        }

        @Override
        protected abstract T self();

        public T outputTo(PrintStream output) {
            this.output = output;
            return this.self();
        }

        public T outputTo(OutputStream stream) {
            try {
                this.output = new PrintStream(stream, false, Charsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException exception) {
                LOGGER.error("Unsupported encoding in OutputStreamReporter. This is an error with the code itself.", (Throwable)exception);
                throw new RuntimeException(exception);
            }
            return this.self();
        }

        public T formattedFor(Locale locale) {
            this.locale = locale;
            return this.self();
        }

        public T withClock(Clock clock) {
            this.clock = clock;
            return this.self();
        }

        public T formattedFor(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this.self();
        }

        public OutputStreamReporter build(Properties props) {
            return new OutputStreamReporter(this, ConfigUtils.propertiesToConfig((Properties)props, (Optional)Optional.of((Object)"metrics.")));
        }
    }

    public static class BuilderImpl
    extends Builder<BuilderImpl> {
        @Override
        protected BuilderImpl self() {
            return this;
        }
    }

    public static class Factory {
        public static BuilderImpl newBuilder() {
            return new BuilderImpl();
        }
    }
}

