/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.apache.gobblin.metrics.Measurements;
import org.apache.gobblin.metrics.Metric;
import org.apache.gobblin.metrics.MetricReport;
import org.apache.gobblin.metrics.reporter.ConfiguredScheduledReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetricReportReporter
extends ConfiguredScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricReportReporter.class);

    public MetricReportReporter(Builder<?> builder, Config config) {
        super(builder, config);
    }

    @Override
    protected void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers, Map<String, Object> tags) {
        ArrayList metrics = Lists.newArrayList();
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            metrics.addAll(this.serializeGauge(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            metrics.addAll(this.serializeCounter(entry.getKey(), (Counting)entry.getValue()));
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            metrics.addAll(this.serializeSnapshot(entry.getKey(), ((Histogram)entry.getValue()).getSnapshot()));
            metrics.addAll(this.serializeCounter(entry.getKey(), (Counting)entry.getValue()));
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            metrics.addAll(this.serializeMetered(entry.getKey(), (Metered)entry.getValue()));
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            metrics.addAll(this.serializeSnapshot(entry.getKey(), ((Timer)entry.getValue()).getSnapshot()));
            metrics.addAll(this.serializeMetered(entry.getKey(), (Metered)entry.getValue()));
            metrics.addAll(this.serializeSingleValue(entry.getKey(), ((Timer)entry.getValue()).getCount(), Measurements.COUNT.getName()));
        }
        HashMap allTags = Maps.newHashMap();
        allTags.putAll(tags);
        allTags.putAll(this.tags);
        Map map = Maps.transformValues((Map)allTags, (Function)new Function<Object, String>(){

            @Nullable
            public String apply(Object input) {
                return input.toString();
            }
        });
        MetricReport report = new MetricReport(map, System.currentTimeMillis(), metrics);
        this.emitReport(report);
    }

    protected abstract void emitReport(MetricReport var1);

    protected List<Metric> serializeGauge(String name, Gauge gauge) {
        ArrayList metrics = Lists.newArrayList();
        try {
            metrics.add(new Metric(name, Double.parseDouble(gauge.getValue().toString())));
        }
        catch (NumberFormatException exception) {
            LOGGER.info("Failed to serialize gauge metric. Not compatible with double value.", (Throwable)exception);
        }
        return metrics;
    }

    protected List<Metric> serializeCounter(String name, Counting counter) {
        return Lists.newArrayList((Object[])new Metric[]{this.serializeValue(name, counter.getCount(), Measurements.COUNT.name())});
    }

    protected List<Metric> serializeMetered(String name, Metered meter) {
        return Lists.newArrayList((Object[])new Metric[]{this.serializeValue(name, meter.getCount(), Measurements.COUNT.name()), this.serializeValue(name, meter.getMeanRate(), Measurements.MEAN_RATE.name()), this.serializeValue(name, meter.getOneMinuteRate(), Measurements.RATE_1MIN.name()), this.serializeValue(name, meter.getFiveMinuteRate(), Measurements.RATE_5MIN.name()), this.serializeValue(name, meter.getFifteenMinuteRate(), Measurements.RATE_15MIN.name())});
    }

    protected List<Metric> serializeSnapshot(String name, Snapshot snapshot) {
        return Lists.newArrayList((Object[])new Metric[]{this.serializeValue(name, snapshot.getMean(), Measurements.MEAN.name()), this.serializeValue(name, snapshot.getMin(), Measurements.MIN.name()), this.serializeValue(name, snapshot.getMax(), Measurements.MAX.name()), this.serializeValue(name, snapshot.getMedian(), Measurements.MEDIAN.name()), this.serializeValue(name, snapshot.get75thPercentile(), Measurements.PERCENTILE_75TH.name()), this.serializeValue(name, snapshot.get95thPercentile(), Measurements.PERCENTILE_95TH.name()), this.serializeValue(name, snapshot.get99thPercentile(), Measurements.PERCENTILE_99TH.name()), this.serializeValue(name, snapshot.get999thPercentile(), Measurements.PERCENTILE_999TH.name())});
    }

    protected List<Metric> serializeSingleValue(String name, Number value, String ... path) {
        return Lists.newArrayList((Object[])new Metric[]{this.serializeValue(name, value, path)});
    }

    protected Metric serializeValue(String name, Number value, String ... path) {
        return new Metric(MetricRegistry.name((String)name, (String[])path), value.doubleValue());
    }

    public static abstract class Builder<T extends ConfiguredScheduledReporter.Builder<T>>
    extends ConfiguredScheduledReporter.Builder<T> {
        protected MetricFilter filter;

        protected Builder() {
            this.name = "MetricReportReporter";
            this.filter = MetricFilter.ALL;
        }

        public T filter(MetricFilter filter) {
            this.filter = filter;
            return this.self();
        }
    }
}

