/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter;

import com.codahale.metrics.Reporter;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.gobblin.metrics.InnerMetricContext;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.RootMetricContext;
import org.apache.gobblin.metrics.context.ReportableContext;
import org.apache.gobblin.metrics.context.filter.ContextFilter;
import org.apache.gobblin.metrics.context.filter.ContextFilterFactory;
import org.apache.gobblin.metrics.notification.MetricContextCleanupNotification;
import org.apache.gobblin.metrics.notification.NewMetricContextNotification;
import org.apache.gobblin.metrics.notification.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextAwareReporter
implements Reporter,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(ContextAwareReporter.class);
    private boolean started;
    private final UUID notificationTargetUUID;
    private final Set<InnerMetricContext> contextsToReport;
    private final ContextFilter contextFilter;
    protected final String name;
    protected final Config config;

    public ContextAwareReporter(String name, Config config) {
        this.name = name;
        this.config = config;
        this.started = false;
        RootMetricContext.get().addNewReporter(this);
        this.notificationTargetUUID = RootMetricContext.get().addNotificationTarget(new Function<Notification, Void>(){

            @Nullable
            public Void apply(Notification input) {
                ContextAwareReporter.this.notificationCallback(input);
                return null;
            }
        });
        this.contextFilter = ContextFilterFactory.createContextFilter(config);
        this.contextsToReport = Sets.newConcurrentHashSet();
        for (MetricContext context : this.contextFilter.getMatchingContexts()) {
            this.contextsToReport.add(context.getInnerMetricContext());
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public final void start() {
        if (this.started) {
            log.warn(String.format("Reporter %s has already been started.", this.name));
            return;
        }
        try {
            this.startImpl();
            this.started = true;
        }
        catch (Exception exception) {
            log.warn(String.format("Reporter %s did not start correctly.", this.name), (Throwable)exception);
        }
    }

    protected void startImpl() {
    }

    public final void stop() {
        if (!this.started) {
            log.warn(String.format("Reporter %s has already been stopped.", this.name));
            return;
        }
        try {
            this.stopImpl();
            this.started = false;
        }
        catch (Exception exception) {
            log.warn(String.format("Reporter %s did not stop correctly.", this.name), (Throwable)exception);
        }
    }

    protected void stopImpl() {
    }

    @Override
    public void close() throws IOException {
        RootMetricContext.get().removeNotificationTarget(this.notificationTargetUUID);
        RootMetricContext.get().removeReporter(this);
    }

    private void notificationCallback(Notification notification) {
        if (notification instanceof MetricContextCleanupNotification) {
            this.removedMetricContext(((MetricContextCleanupNotification)notification).getMetricContext());
        }
        if (notification instanceof NewMetricContextNotification) {
            this.newMetricContext(((NewMetricContextNotification)notification).getMetricContext());
        }
    }

    protected void removedMetricContext(InnerMetricContext context) {
        this.contextsToReport.remove(context);
        if (context.getParent().isPresent() && this.contextFilter.shouldReplaceByParent(context)) {
            this.contextsToReport.add(((MetricContext)context.getParent().get()).getInnerMetricContext());
        }
    }

    protected void newMetricContext(MetricContext context) {
        if (this.contextFilter.matches(context)) {
            this.contextsToReport.add(context.getInnerMetricContext());
        }
    }

    protected boolean shouldReportInnerMetricContext(InnerMetricContext context) {
        return this.contextsToReport.contains(context);
    }

    protected Iterable<ReportableContext> getMetricContextsToReport() {
        return ImmutableSet.copyOf(this.contextsToReport);
    }
}

